/*
 * Decompiled with CFR 0.152.
 */
package com.sparrowwallet.hummingbird.registry;

import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.Map;
import co.nstant.in.cbor.model.SimpleValue;
import co.nstant.in.cbor.model.UnicodeString;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.sparrowwallet.hummingbird.registry.CryptoHDKey;
import com.sparrowwallet.hummingbird.registry.RegistryType;
import com.sparrowwallet.hummingbird.registry.URCoinInfo;
import com.sparrowwallet.hummingbird.registry.URKeypath;

public class URHDKey
extends CryptoHDKey {
    public URHDKey(byte[] key, byte[] chainCode) {
        super(key, chainCode);
    }

    public URHDKey(Boolean privateKey, byte[] key, byte[] chainCode, URCoinInfo useInfo, URKeypath origin, URKeypath children, byte[] parentFingerprint) {
        super(privateKey, key, chainCode, useInfo, origin, children, parentFingerprint);
    }

    public URHDKey(Boolean privateKey, byte[] key, byte[] chainCode, URCoinInfo useInfo, URKeypath origin, URKeypath children, byte[] parentFingerprint, String name, String note) {
        super(privateKey, key, chainCode, useInfo, origin, children, parentFingerprint, name, note);
    }

    @Override
    public DataItem toCbor() {
        DataItem children;
        DataItem origin;
        Map map = (Map)super.toCbor();
        DataItem useinfo = map.get((DataItem)new UnsignedInteger(5L));
        if (useinfo != null) {
            useinfo.setTag((long)RegistryType.COIN_INFO.getTag().intValue());
        }
        if ((origin = map.get((DataItem)new UnsignedInteger(6L))) != null) {
            origin.setTag((long)RegistryType.KEYPATH.getTag().intValue());
        }
        if ((children = map.get((DataItem)new UnsignedInteger(7L))) != null) {
            children.setTag((long)RegistryType.KEYPATH.getTag().intValue());
        }
        return map;
    }

    @Override
    public RegistryType getRegistryType() {
        return RegistryType.HDKEY;
    }

    public static URHDKey fromCbor(DataItem item) {
        boolean isMasterKey = false;
        Boolean isPrivateKey = null;
        byte[] keyData = null;
        byte[] chainCode = null;
        URCoinInfo useInfo = null;
        URKeypath origin = null;
        URKeypath children = null;
        byte[] parentFingerprint = null;
        String name = null;
        String note = null;
        Map map = (Map)item;
        for (DataItem key : map.getKeys()) {
            UnsignedInteger uintKey = (UnsignedInteger)key;
            int intKey = uintKey.getValue().intValue();
            if (intKey == 1) {
                isMasterKey = map.get((DataItem)uintKey) == SimpleValue.TRUE;
                continue;
            }
            if (intKey == 2) {
                isPrivateKey = map.get((DataItem)uintKey) == SimpleValue.TRUE;
                continue;
            }
            if (intKey == 3) {
                keyData = ((ByteString)map.get((DataItem)uintKey)).getBytes();
                continue;
            }
            if (intKey == 4) {
                chainCode = ((ByteString)map.get((DataItem)uintKey)).getBytes();
                continue;
            }
            if (intKey == 5) {
                useInfo = URCoinInfo.fromCbor(map.get((DataItem)uintKey));
                continue;
            }
            if (intKey == 6) {
                origin = URKeypath.fromCbor(map.get((DataItem)uintKey));
                continue;
            }
            if (intKey == 7) {
                children = URKeypath.fromCbor(map.get((DataItem)uintKey));
                continue;
            }
            if (intKey == 8) {
                parentFingerprint = URHDKey.bigIntegerToBytes(((UnsignedInteger)map.get((DataItem)uintKey)).getValue(), 4);
                continue;
            }
            if (intKey == 9) {
                name = ((UnicodeString)map.get((DataItem)uintKey)).getString();
                continue;
            }
            if (intKey != 10) continue;
            note = ((UnicodeString)map.get((DataItem)uintKey)).getString();
        }
        if (keyData == null) {
            throw new IllegalStateException("Key data is null");
        }
        if (isMasterKey) {
            if (chainCode == null) {
                throw new IllegalStateException("Chain code data is null");
            }
            return new URHDKey(keyData, chainCode);
        }
        return new URHDKey(isPrivateKey, keyData, chainCode, useInfo, origin, children, parentFingerprint, name, note);
    }
}

