/*
 * Decompiled with CFR 0.152.
 */
package com.sparrowwallet.hummingbird.registry;

import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.Map;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.sparrowwallet.hummingbird.registry.CryptoKeypath;
import com.sparrowwallet.hummingbird.registry.RegistryType;
import com.sparrowwallet.hummingbird.registry.pathcomponent.PathComponent;
import java.util.ArrayList;
import java.util.List;

public class URKeypath
extends CryptoKeypath {
    public URKeypath(List<PathComponent> components, byte[] sourceFingerprint) {
        super(components, sourceFingerprint);
    }

    public URKeypath(List<PathComponent> components, byte[] sourceFingerprint, Integer depth) {
        super(components, sourceFingerprint, depth);
    }

    @Override
    public RegistryType getRegistryType() {
        return RegistryType.KEYPATH;
    }

    public static URKeypath fromCbor(DataItem item) {
        List<PathComponent> components = new ArrayList<PathComponent>();
        byte[] sourceFingerprint = null;
        Integer depth = null;
        Map map = (Map)item;
        for (DataItem key : map.getKeys()) {
            UnsignedInteger uintKey = (UnsignedInteger)key;
            int intKey = uintKey.getValue().intValue();
            if (intKey == 1) {
                components = PathComponent.fromCbor(map.get(key));
                continue;
            }
            if (intKey == 2) {
                sourceFingerprint = URKeypath.bigIntegerToBytes(((UnsignedInteger)map.get(key)).getValue(), 4);
                continue;
            }
            if (intKey != 3) continue;
            depth = ((UnsignedInteger)map.get(key)).getValue().intValue();
        }
        return new URKeypath(components, sourceFingerprint, depth);
    }
}

