/*
 * Decompiled with CFR 0.152.
 */
package com.sparrowwallet.hummingbird.registry;

import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.Map;
import co.nstant.in.cbor.model.UnicodeString;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.sparrowwallet.hummingbird.registry.RegistryItem;
import com.sparrowwallet.hummingbird.registry.RegistryType;
import com.sparrowwallet.hummingbird.registry.URAddress;
import com.sparrowwallet.hummingbird.registry.URECKey;
import com.sparrowwallet.hummingbird.registry.URHDKey;
import java.util.ArrayList;
import java.util.List;

public class UROutputDescriptor
extends RegistryItem {
    public static final long SOURCE = 1L;
    public static final long KEYS = 2L;
    public static final long NAME = 3L;
    public static final long NOTE = 4L;
    private final String source;
    private final List<RegistryItem> keys;
    private final String name;
    private final String note;

    public UROutputDescriptor(String source) {
        this(source, null);
    }

    public UROutputDescriptor(String source, List<RegistryItem> keys) {
        this(source, keys, null, null);
    }

    public UROutputDescriptor(String source, List<RegistryItem> keys, String name, String note) {
        this.source = source;
        this.keys = keys;
        this.name = name;
        this.note = note;
        if (keys != null && !keys.stream().allMatch(item -> item instanceof URHDKey || item instanceof URECKey || item instanceof URAddress)) {
            throw new IllegalArgumentException("All keys must be one of HDKey, ECKey or Address");
        }
    }

    public String getSource() {
        return this.source;
    }

    public List<RegistryItem> getKeys() {
        return this.keys;
    }

    public String getName() {
        return this.name;
    }

    public String getNote() {
        return this.note;
    }

    @Override
    public DataItem toCbor() {
        Map map = new Map();
        map.put((DataItem)new UnsignedInteger(1L), (DataItem)new UnicodeString(this.source));
        if (this.keys != null && !this.keys.isEmpty()) {
            Array array = new Array();
            for (RegistryItem key : this.keys) {
                DataItem keyItem = key.toCbor();
                if (key instanceof URHDKey) {
                    keyItem.setTag((long)RegistryType.HDKEY.getTag().intValue());
                } else if (key instanceof URECKey) {
                    keyItem.setTag((long)RegistryType.ECKEY.getTag().intValue());
                } else if (key instanceof URAddress) {
                    keyItem.setTag((long)RegistryType.ADDRESS.getTag().intValue());
                }
                array.add(keyItem);
            }
            map.put((DataItem)new UnsignedInteger(2L), (DataItem)array);
        }
        if (this.name != null) {
            map.put((DataItem)new UnsignedInteger(3L), (DataItem)new UnicodeString(this.name));
        }
        if (this.note != null) {
            map.put((DataItem)new UnsignedInteger(4L), (DataItem)new UnicodeString(this.note));
        }
        return map;
    }

    @Override
    public RegistryType getRegistryType() {
        return RegistryType.OUTPUT_DESCRIPTOR;
    }

    public static UROutputDescriptor fromCbor(DataItem item) {
        String source = null;
        ArrayList<RegistryItem> keys = null;
        String name = null;
        String note = null;
        Map map = (Map)item;
        for (DataItem key : map.getKeys()) {
            UnsignedInteger uintKey = (UnsignedInteger)key;
            int intKey = uintKey.getValue().intValue();
            if ((long)intKey == 1L) {
                source = ((UnicodeString)map.get(key)).getString();
                continue;
            }
            if ((long)intKey == 2L) {
                Array keyArray = (Array)map.get(key);
                keys = new ArrayList<RegistryItem>(keyArray.getDataItems().size());
                for (DataItem keyItem : keyArray.getDataItems()) {
                    if (keyItem.getTag().getValue() == (long)RegistryType.HDKEY.getTag().intValue()) {
                        keys.add(URHDKey.fromCbor(keyItem));
                        continue;
                    }
                    if (keyItem.getTag().getValue() == (long)RegistryType.ECKEY.getTag().intValue()) {
                        keys.add(URECKey.fromCbor(keyItem));
                        continue;
                    }
                    if (keyItem.getTag().getValue() == (long)RegistryType.ADDRESS.getTag().intValue()) {
                        keys.add(URAddress.fromCbor(keyItem));
                        continue;
                    }
                    throw new IllegalArgumentException("All keys must be one of HDKey, ECKey or Address");
                }
                continue;
            }
            if ((long)intKey == 3L) {
                name = ((UnicodeString)map.get(key)).getString();
                continue;
            }
            if ((long)intKey != 4L) continue;
            note = ((UnicodeString)map.get(key)).getString();
        }
        if (source == null) {
            throw new IllegalStateException("Source is null");
        }
        return new UROutputDescriptor(source, keys, name, note);
    }
}

