/*
 * Decompiled with CFR 0.152.
 */
package com.sparrowwallet.hummingbird.registry;

import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.Map;
import co.nstant.in.cbor.model.UnicodeString;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.sparrowwallet.hummingbird.registry.CryptoSeed;
import com.sparrowwallet.hummingbird.registry.RegistryType;
import java.util.Date;

public class URSeed
extends CryptoSeed {
    public URSeed(byte[] seed, Date birthdate) {
        super(seed, birthdate);
    }

    public URSeed(byte[] seed, Date birthdate, String name, String note) {
        super(seed, birthdate, name, note);
    }

    @Override
    public RegistryType getRegistryType() {
        return RegistryType.SEED;
    }

    public static URSeed fromCbor(DataItem item) {
        byte[] seed = null;
        Date birthdate = null;
        String name = null;
        String note = null;
        Map map = (Map)item;
        for (DataItem key : map.getKeys()) {
            UnsignedInteger uintKey = (UnsignedInteger)key;
            int intKey = uintKey.getValue().intValue();
            if ((long)intKey == 1L) {
                seed = ((ByteString)map.get(key)).getBytes();
                continue;
            }
            if ((long)intKey == 2L) {
                birthdate = new Date(((UnsignedInteger)map.get(key)).getValue().longValue() * 1000L * 60L * 60L * 24L);
                continue;
            }
            if ((long)intKey == 3L) {
                name = ((UnicodeString)map.get(key)).getString();
                continue;
            }
            if ((long)intKey != 4L) continue;
            note = ((UnicodeString)map.get(key)).getString();
        }
        if (seed == null) {
            throw new IllegalStateException("Seed is null");
        }
        return new URSeed(seed, birthdate, name, note);
    }
}

