/*
 * Decompiled with CFR 0.152.
 */
package com.sparrowwallet.hummingbird.registry.pathcomponent;

import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.SimpleValue;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.sparrowwallet.hummingbird.registry.pathcomponent.IndexPathComponent;
import com.sparrowwallet.hummingbird.registry.pathcomponent.PairPathComponent;
import com.sparrowwallet.hummingbird.registry.pathcomponent.RangePathComponent;
import com.sparrowwallet.hummingbird.registry.pathcomponent.WildcardPathComponent;
import java.util.ArrayList;
import java.util.List;

public abstract class PathComponent {
    public static final int HARDENED_BIT = Integer.MIN_VALUE;

    public static DataItem toCbor(List<PathComponent> components) {
        Array componentArray = new Array();
        for (PathComponent pathComponent : components) {
            Array array;
            if (pathComponent instanceof WildcardPathComponent) {
                WildcardPathComponent wildcardPathComponent = (WildcardPathComponent)pathComponent;
                componentArray.add((DataItem)new Array());
                componentArray.add((DataItem)(wildcardPathComponent.isHardened() ? SimpleValue.TRUE : SimpleValue.FALSE));
                continue;
            }
            if (pathComponent instanceof RangePathComponent) {
                RangePathComponent rangePathComponent = (RangePathComponent)pathComponent;
                array = new Array();
                array.add((DataItem)new UnsignedInteger((long)rangePathComponent.getStart()));
                array.add((DataItem)new UnsignedInteger((long)rangePathComponent.getEnd()));
                componentArray.add((DataItem)array);
                componentArray.add((DataItem)(rangePathComponent.isHardened() ? SimpleValue.TRUE : SimpleValue.FALSE));
                continue;
            }
            if (pathComponent instanceof PairPathComponent) {
                PairPathComponent pairPathComponent = (PairPathComponent)pathComponent;
                array = new Array();
                array.add((DataItem)new UnsignedInteger((long)pairPathComponent.getExternal().getIndex()));
                array.add((DataItem)(pairPathComponent.getExternal().isHardened() ? SimpleValue.TRUE : SimpleValue.FALSE));
                array.add((DataItem)new UnsignedInteger((long)pairPathComponent.getInternal().getIndex()));
                array.add((DataItem)(pairPathComponent.getInternal().isHardened() ? SimpleValue.TRUE : SimpleValue.FALSE));
                componentArray.add((DataItem)array);
                continue;
            }
            if (pathComponent instanceof IndexPathComponent) {
                IndexPathComponent indexPathComponent = (IndexPathComponent)pathComponent;
                componentArray.add((DataItem)new UnsignedInteger((long)indexPathComponent.getIndex()));
                componentArray.add((DataItem)(indexPathComponent.isHardened() ? SimpleValue.TRUE : SimpleValue.FALSE));
                continue;
            }
            throw new IllegalArgumentException("Unknown path component of " + pathComponent.getClass());
        }
        return componentArray;
    }

    public static List<PathComponent> fromCbor(DataItem item) {
        ArrayList<PathComponent> components = new ArrayList<PathComponent>();
        Array componentArray = (Array)item;
        for (int i = 0; i < componentArray.getDataItems().size(); ++i) {
            DataItem component = (DataItem)componentArray.getDataItems().get(i);
            if (component instanceof Array) {
                Array subcomponentArray = (Array)component;
                if (subcomponentArray.getDataItems().isEmpty()) {
                    boolean hardened = componentArray.getDataItems().get(++i) == SimpleValue.TRUE;
                    components.add(new WildcardPathComponent(hardened));
                    continue;
                }
                if (subcomponentArray.getDataItems().size() == 2) {
                    boolean hardened = componentArray.getDataItems().get(++i) == SimpleValue.TRUE;
                    UnsignedInteger startIndex = (UnsignedInteger)subcomponentArray.getDataItems().get(0);
                    UnsignedInteger endIndex = (UnsignedInteger)subcomponentArray.getDataItems().get(1);
                    components.add(new RangePathComponent(startIndex.getValue().intValue(), endIndex.getValue().intValue(), hardened));
                    continue;
                }
                if (subcomponentArray.getDataItems().size() != 4) continue;
                UnsignedInteger externalIndex = (UnsignedInteger)subcomponentArray.getDataItems().get(0);
                boolean externalHardened = subcomponentArray.getDataItems().get(1) == SimpleValue.TRUE;
                IndexPathComponent externalPathComponent = new IndexPathComponent(externalIndex.getValue().intValue(), externalHardened);
                UnsignedInteger internalIndex = (UnsignedInteger)subcomponentArray.getDataItems().get(2);
                boolean internalHardened = subcomponentArray.getDataItems().get(3) == SimpleValue.TRUE;
                IndexPathComponent internalPathComponent = new IndexPathComponent(internalIndex.getValue().intValue(), internalHardened);
                components.add(new PairPathComponent(externalPathComponent, internalPathComponent));
                continue;
            }
            if (!(component instanceof UnsignedInteger)) continue;
            UnsignedInteger index = (UnsignedInteger)component;
            boolean hardened = componentArray.getDataItems().get(++i) == SimpleValue.TRUE;
            components.add(new IndexPathComponent(index.getValue().intValue(), hardened));
        }
        return components;
    }
}

