/*
 * Decompiled with CFR 0.152.
 */
package com.sparrowwallet.hummingbird.registry.pathcomponent;

import com.sparrowwallet.hummingbird.registry.pathcomponent.PathComponent;

public class RangePathComponent
extends PathComponent {
    private final int start;
    private final int end;
    private final boolean hardened;

    public RangePathComponent(int start, int end, boolean hardened) {
        this.start = start;
        this.end = end;
        this.hardened = hardened;
        if ((start & Integer.MIN_VALUE) != 0 || (end & Integer.MIN_VALUE) != 0) {
            throw new IllegalArgumentException("Invalid range [" + start + ", " + end + "] - most significant bit cannot be set");
        }
        if (start >= end) {
            throw new IllegalArgumentException("Invalid range [" + start + ", " + end + "] - start must be lower than end");
        }
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public boolean isHardened() {
        return this.hardened;
    }

    public String toString() {
        return "[" + this.start + (this.hardened ? "'" : "") + "-" + this.end + (this.hardened ? "'" : "") + "]";
    }
}

