/*
 * Decompiled with CFR 0.152.
 */
package com.spearline.watchrtc.logger;

import android.util.Log;
import androidx.annotation.Keep;
import com.spearline.watchrtc.logger.ILogger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004H\u0016J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004H\u0016J\u0018\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/spearline/watchrtc/logger/WatchRTCLoggerImpl;", "Lcom/spearline/watchrtc/logger/ILogger;", "()V", "sdkTag", "", "error", "", "tag", "message", "t", "", "info", "log", "watch-rtc-sdk_release"})
@Keep
public final class WatchRTCLoggerImpl
implements ILogger {
    @NotNull
    private final String sdkTag;

    public WatchRTCLoggerImpl() {
        this.sdkTag = "WatchRTC";
    }

    @Override
    public void info(@NotNull String string, @NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"message");
    }

    @Override
    public void log(@NotNull String string, @NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"message");
        Log.d((String)(this.sdkTag + '-' + string), (String)string2);
    }

    @Override
    public void error(@NotNull String string, @NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"message");
        Log.e((String)(this.sdkTag + '-' + string), (String)string2);
    }

    @Override
    public void error(@NotNull String string, @NotNull String string2, @NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"message");
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"t");
        Log.e((String)(this.sdkTag + '-' + string), (String)string2, (Throwable)throwable);
    }
}

