/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands;

import com.spectralogic.ds3client.commands.interfaces.AbstractRequest;
import com.spectralogic.ds3client.models.Contents;
import com.spectralogic.ds3client.models.delete.Delete;
import com.spectralogic.ds3client.models.delete.DeleteObject;
import com.spectralogic.ds3client.networking.HttpVerb;
import com.spectralogic.ds3client.serializer.XmlOutput;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class DeleteObjectsRequest
extends AbstractRequest {
    private final List<DeleteObject> objects;
    private final String bucketName;
    private boolean quiet = false;
    private long size;

    public DeleteObjectsRequest(String bucketName, List<String> objects) {
        this.bucketName = bucketName;
        this.getQueryParams().put("delete", null);
        this.objects = DeleteObjectsRequest.namesToDeleteObjects(objects);
    }

    public DeleteObjectsRequest(String bucketName, Iterable<Contents> objects) {
        this.bucketName = bucketName;
        this.getQueryParams().put("delete", null);
        this.objects = DeleteObjectsRequest.contentsToDeleteObjects(objects);
    }

    private static List<DeleteObject> contentsToDeleteObjects(Iterable<Contents> objects) {
        ArrayList<DeleteObject> objectsToDelete = new ArrayList<DeleteObject>();
        for (Contents obj : objects) {
            objectsToDelete.add(new DeleteObject(obj.getKey(), obj.getVersionId()));
        }
        return objectsToDelete;
    }

    private static List<DeleteObject> namesToDeleteObjects(Iterable<String> objNames) {
        ArrayList<DeleteObject> objectsToDelete = new ArrayList<DeleteObject>();
        for (String objName : objNames) {
            objectsToDelete.add(new DeleteObject(objName));
        }
        return objectsToDelete;
    }

    public DeleteObjectsRequest withQuiet(boolean quiet) {
        this.quiet = quiet;
        return this;
    }

    @Override
    public InputStream getStream() {
        Delete delete = new Delete();
        delete.setQuiet(this.quiet);
        delete.setDeleteObjectList(this.objects);
        String xmlOutput = XmlOutput.toXml(delete);
        byte[] stringBytes = xmlOutput.getBytes(StandardCharsets.UTF_8);
        this.size = stringBytes.length;
        return new ByteArrayInputStream(stringBytes);
    }

    @Override
    public HttpVerb getVerb() {
        return HttpVerb.POST;
    }

    @Override
    public String getPath() {
        return "/" + this.bucketName;
    }

    public List<DeleteObject> getObjects() {
        return this.objects;
    }

    public boolean getQuiet() {
        return this.quiet;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    @Override
    public long getSize() {
        return this.size;
    }
}

