/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.parsers;

import com.spectralogic.ds3client.commands.parsers.interfaces.AbstractResponseParser;
import com.spectralogic.ds3client.commands.parsers.utils.ResponseParserUtils;
import com.spectralogic.ds3client.commands.spectrads3.GetJobCreationFailuresSpectraS3Response;
import com.spectralogic.ds3client.models.JobCreationFailedList;
import com.spectralogic.ds3client.networking.WebResponse;
import com.spectralogic.ds3client.serializer.XmlOutput;
import java.io.IOException;
import java.io.InputStream;

public class GetJobCreationFailuresSpectraS3ResponseParser
extends AbstractResponseParser<GetJobCreationFailuresSpectraS3Response> {
    private final int[] expectedStatusCodes = new int[]{200};

    @Override
    public GetJobCreationFailuresSpectraS3Response parseXmlResponse(WebResponse response) throws IOException {
        int statusCode = response.getStatusCode();
        Integer pagingTruncated = this.parseIntHeader("page-truncated");
        Integer pagingTotalResultCount = this.parseIntHeader("total-result-count");
        if (ResponseParserUtils.validateStatusCode(statusCode, this.expectedStatusCodes)) {
            switch (statusCode) {
                case 200: {
                    try (InputStream inputStream = response.getResponseStream();){
                        JobCreationFailedList result = XmlOutput.fromXml(inputStream, JobCreationFailedList.class);
                        GetJobCreationFailuresSpectraS3Response getJobCreationFailuresSpectraS3Response = new GetJobCreationFailuresSpectraS3Response(result, pagingTotalResultCount, pagingTruncated, this.getChecksum(), this.getChecksumType());
                        return getJobCreationFailuresSpectraS3Response;
                    }
                }
            }
            assert (false) : "validateStatusCode should have made it impossible to reach this line";
        }
        throw ResponseParserUtils.createFailedRequest(response, this.expectedStatusCodes);
    }
}

