/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.parsers;

import com.spectralogic.ds3client.commands.HeadBucketResponse;
import com.spectralogic.ds3client.commands.parsers.interfaces.AbstractResponseParser;
import com.spectralogic.ds3client.commands.parsers.utils.ResponseParserUtils;
import com.spectralogic.ds3client.networking.WebResponse;
import java.io.IOException;

public class HeadBucketResponseParser
extends AbstractResponseParser<HeadBucketResponse> {
    private final int[] expectedStatusCodes = new int[]{200, 403, 404};

    @Override
    public HeadBucketResponse parseXmlResponse(WebResponse response) throws IOException {
        int statusCode = response.getStatusCode();
        if (ResponseParserUtils.validateStatusCode(statusCode, this.expectedStatusCodes)) {
            switch (statusCode) {
                case 200: {
                    return new HeadBucketResponse(HeadBucketResponse.Status.EXISTS, this.getChecksum(), this.getChecksumType());
                }
                case 403: {
                    return new HeadBucketResponse(HeadBucketResponse.Status.NOTAUTHORIZED, this.getChecksum(), this.getChecksumType());
                }
                case 404: {
                    return new HeadBucketResponse(HeadBucketResponse.Status.DOESNTEXIST, this.getChecksum(), this.getChecksumType());
                }
            }
            assert (false) : "validateStatusCode should have made it impossible to reach this line";
        }
        throw ResponseParserUtils.createFailedRequest(response, this.expectedStatusCodes);
    }
}

