/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.spectrads3;

import com.spectralogic.ds3client.commands.interfaces.AbstractRequest;
import com.spectralogic.ds3client.models.bulk.Ds3Object;
import com.spectralogic.ds3client.models.bulk.Ds3ObjectList;
import com.spectralogic.ds3client.networking.HttpVerb;
import com.spectralogic.ds3client.serializer.XmlOutput;
import com.spectralogic.ds3client.utils.Guard;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;

public class EjectStorageDomainBlobsSpectraS3Request
extends AbstractRequest {
    private final String bucketId;
    private final String storageDomain;
    private final List<Ds3Object> objects;
    private String ejectLabel;
    private String ejectLocation;
    private long size = 0L;

    public EjectStorageDomainBlobsSpectraS3Request(String bucketId, List<Ds3Object> objects, String storageDomain) {
        this.bucketId = bucketId;
        this.storageDomain = storageDomain;
        this.objects = objects;
        this.getQueryParams().put("operation", "eject");
        this.getQueryParams().put("blobs", null);
        this.updateQueryParam("bucket_id", bucketId);
        this.updateQueryParam("storage_domain", storageDomain);
    }

    public EjectStorageDomainBlobsSpectraS3Request withEjectLabel(String ejectLabel) {
        this.ejectLabel = ejectLabel;
        this.updateQueryParam("eject_label", ejectLabel);
        return this;
    }

    public EjectStorageDomainBlobsSpectraS3Request withEjectLocation(String ejectLocation) {
        this.ejectLocation = ejectLocation;
        this.updateQueryParam("eject_location", ejectLocation);
        return this;
    }

    @Override
    public InputStream getStream() {
        if (Guard.isNullOrEmpty(this.objects)) {
            return null;
        }
        Ds3ObjectList objects = new Ds3ObjectList();
        objects.setObjects(this.objects);
        String xmlOutput = XmlOutput.toXml(objects, false);
        byte[] stringBytes = xmlOutput.getBytes(StandardCharsets.UTF_8);
        this.size = stringBytes.length;
        return new ByteArrayInputStream(stringBytes);
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public HttpVerb getVerb() {
        return HttpVerb.PUT;
    }

    @Override
    public String getPath() {
        return "/_rest_/tape";
    }

    public String getBucketId() {
        return this.bucketId;
    }

    public String getStorageDomain() {
        return this.storageDomain;
    }

    public List<Ds3Object> getObjects() {
        return this.objects;
    }

    public String getEjectLabel() {
        return this.ejectLabel;
    }

    public String getEjectLocation() {
        return this.ejectLocation;
    }
}

