/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.spectrads3;

import com.spectralogic.ds3client.commands.interfaces.AbstractRequest;
import com.spectralogic.ds3client.networking.HttpVerb;
import java.util.UUID;

public class EjectTapeSpectraS3Request
extends AbstractRequest {
    private final String tapeId;
    private String ejectLabel;
    private String ejectLocation;

    public EjectTapeSpectraS3Request(UUID tapeId) {
        this.tapeId = tapeId.toString();
        this.getQueryParams().put("operation", "eject");
    }

    public EjectTapeSpectraS3Request(String tapeId) {
        this.tapeId = tapeId;
        this.getQueryParams().put("operation", "eject");
    }

    public EjectTapeSpectraS3Request withEjectLabel(String ejectLabel) {
        this.ejectLabel = ejectLabel;
        this.updateQueryParam("eject_label", ejectLabel);
        return this;
    }

    public EjectTapeSpectraS3Request withEjectLocation(String ejectLocation) {
        this.ejectLocation = ejectLocation;
        this.updateQueryParam("eject_location", ejectLocation);
        return this;
    }

    @Override
    public HttpVerb getVerb() {
        return HttpVerb.PUT;
    }

    @Override
    public String getPath() {
        return "/_rest_/tape/" + this.tapeId;
    }

    public String getTapeId() {
        return this.tapeId;
    }

    public String getEjectLabel() {
        return this.ejectLabel;
    }

    public String getEjectLocation() {
        return this.ejectLocation;
    }
}

