/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.spectrads3;

import com.spectralogic.ds3client.BulkCommand;
import com.spectralogic.ds3client.commands.interfaces.BulkRequest;
import com.spectralogic.ds3client.models.JobChunkClientProcessingOrderGuarantee;
import com.spectralogic.ds3client.models.Priority;
import com.spectralogic.ds3client.models.bulk.Ds3Object;

public class GetBulkJobSpectraS3Request
extends BulkRequest {
    private boolean aggregating;
    private JobChunkClientProcessingOrderGuarantee chunkClientProcessingOrderGuarantee;
    private boolean deadJobCleanupAllowed;
    private boolean implicitJobIdResolution;
    private String name;
    private boolean protectedFlag;

    public GetBulkJobSpectraS3Request(String bucketName, Iterable<Ds3Object> objects) {
        super(bucketName, objects);
        this.getQueryParams().put("operation", "start_bulk_get");
    }

    public GetBulkJobSpectraS3Request withAggregating(boolean aggregating) {
        this.aggregating = aggregating;
        this.updateQueryParam("aggregating", aggregating);
        return this;
    }

    public GetBulkJobSpectraS3Request withChunkClientProcessingOrderGuarantee(JobChunkClientProcessingOrderGuarantee chunkClientProcessingOrderGuarantee) {
        this.chunkClientProcessingOrderGuarantee = chunkClientProcessingOrderGuarantee;
        this.updateQueryParam("chunk_client_processing_order_guarantee", chunkClientProcessingOrderGuarantee);
        return this;
    }

    public GetBulkJobSpectraS3Request withDeadJobCleanupAllowed(boolean deadJobCleanupAllowed) {
        this.deadJobCleanupAllowed = deadJobCleanupAllowed;
        this.updateQueryParam("dead_job_cleanup_allowed", deadJobCleanupAllowed);
        return this;
    }

    public GetBulkJobSpectraS3Request withImplicitJobIdResolution(boolean implicitJobIdResolution) {
        this.implicitJobIdResolution = implicitJobIdResolution;
        this.updateQueryParam("implicit_job_id_resolution", implicitJobIdResolution);
        return this;
    }

    public GetBulkJobSpectraS3Request withName(String name) {
        this.name = name;
        this.updateQueryParam("name", name);
        return this;
    }

    @Override
    public GetBulkJobSpectraS3Request withPriority(Priority priority) {
        super.withPriority(priority);
        return this;
    }

    public GetBulkJobSpectraS3Request withProtected(boolean protectedFlag) {
        this.protectedFlag = protectedFlag;
        this.updateQueryParam("protected", protectedFlag);
        return this;
    }

    public boolean getAggregating() {
        return this.aggregating;
    }

    public JobChunkClientProcessingOrderGuarantee getChunkClientProcessingOrderGuarantee() {
        return this.chunkClientProcessingOrderGuarantee;
    }

    public boolean getDeadJobCleanupAllowed() {
        return this.deadJobCleanupAllowed;
    }

    public boolean getImplicitJobIdResolution() {
        return this.implicitJobIdResolution;
    }

    public String getName() {
        return this.name;
    }

    public boolean getProtected() {
        return this.protectedFlag;
    }

    @Override
    public BulkCommand getCommand() {
        return BulkCommand.GET;
    }
}

