/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.spectrads3;

import com.spectralogic.ds3client.commands.interfaces.AbstractRequest;
import com.spectralogic.ds3client.models.bulk.Ds3Object;
import com.spectralogic.ds3client.models.bulk.Ds3ObjectList;
import com.spectralogic.ds3client.networking.HttpVerb;
import com.spectralogic.ds3client.serializer.XmlOutput;
import com.spectralogic.ds3client.utils.Guard;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;

public class GetPhysicalPlacementForObjectsWithFullDetailsSpectraS3Request
extends AbstractRequest {
    private final String bucketName;
    private final List<Ds3Object> objects;
    private String storageDomain;
    private long size = 0L;

    public GetPhysicalPlacementForObjectsWithFullDetailsSpectraS3Request(String bucketName, List<Ds3Object> objects) {
        this.bucketName = bucketName;
        this.objects = objects;
        this.getQueryParams().put("operation", "get_physical_placement");
        this.getQueryParams().put("full_details", null);
    }

    public GetPhysicalPlacementForObjectsWithFullDetailsSpectraS3Request withStorageDomain(String storageDomain) {
        this.storageDomain = storageDomain;
        this.updateQueryParam("storage_domain", storageDomain);
        return this;
    }

    @Override
    public InputStream getStream() {
        if (Guard.isNullOrEmpty(this.objects)) {
            return null;
        }
        Ds3ObjectList objects = new Ds3ObjectList();
        objects.setObjects(this.objects);
        String xmlOutput = XmlOutput.toXml(objects, false);
        byte[] stringBytes = xmlOutput.getBytes(StandardCharsets.UTF_8);
        this.size = stringBytes.length;
        return new ByteArrayInputStream(stringBytes);
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public HttpVerb getVerb() {
        return HttpVerb.PUT;
    }

    @Override
    public String getPath() {
        return "/_rest_/bucket/" + this.bucketName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public List<Ds3Object> getObjects() {
        return this.objects;
    }

    public String getStorageDomain() {
        return this.storageDomain;
    }
}

