/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.spectrads3;

import com.spectralogic.ds3client.commands.interfaces.AbstractPaginationRequest;
import com.spectralogic.ds3client.models.PoolHealth;
import com.spectralogic.ds3client.models.PoolState;
import com.spectralogic.ds3client.models.PoolType;
import com.spectralogic.ds3client.networking.HttpVerb;
import java.util.Date;
import java.util.UUID;

public class GetPoolsSpectraS3Request
extends AbstractPaginationRequest {
    private boolean assignedToStorageDomain;
    private String bucketId;
    private String guid;
    private PoolHealth health;
    private boolean lastPage;
    private Date lastVerified;
    private String name;
    private int pageLength;
    private int pageOffset;
    private String pageStartMarker;
    private String partitionId;
    private boolean poweredOn;
    private PoolState state;
    private String storageDomainMemberId;
    private PoolType type;

    public GetPoolsSpectraS3Request withAssignedToStorageDomain(boolean assignedToStorageDomain) {
        this.assignedToStorageDomain = assignedToStorageDomain;
        this.updateQueryParam("assigned_to_storage_domain", assignedToStorageDomain);
        return this;
    }

    public GetPoolsSpectraS3Request withBucketId(String bucketId) {
        this.bucketId = bucketId;
        this.updateQueryParam("bucket_id", bucketId);
        return this;
    }

    public GetPoolsSpectraS3Request withGuid(String guid) {
        this.guid = guid;
        this.updateQueryParam("guid", guid);
        return this;
    }

    public GetPoolsSpectraS3Request withHealth(PoolHealth health) {
        this.health = health;
        this.updateQueryParam("health", health);
        return this;
    }

    public GetPoolsSpectraS3Request withLastPage(boolean lastPage) {
        this.lastPage = lastPage;
        if (this.lastPage) {
            this.getQueryParams().put("last_page", null);
        } else {
            this.getQueryParams().remove("last_page");
        }
        return this;
    }

    public GetPoolsSpectraS3Request withLastVerified(Date lastVerified) {
        this.lastVerified = lastVerified;
        this.updateQueryParam("last_verified", lastVerified);
        return this;
    }

    public GetPoolsSpectraS3Request withName(String name) {
        this.name = name;
        this.updateQueryParam("name", name);
        return this;
    }

    public GetPoolsSpectraS3Request withPageLength(int pageLength) {
        this.pageLength = pageLength;
        this.updateQueryParam("page_length", pageLength);
        return this;
    }

    public GetPoolsSpectraS3Request withPageOffset(int pageOffset) {
        this.pageOffset = pageOffset;
        this.updateQueryParam("page_offset", pageOffset);
        return this;
    }

    public GetPoolsSpectraS3Request withPageStartMarker(UUID pageStartMarker) {
        this.pageStartMarker = pageStartMarker.toString();
        this.updateQueryParam("page_start_marker", pageStartMarker);
        return this;
    }

    public GetPoolsSpectraS3Request withPageStartMarker(String pageStartMarker) {
        this.pageStartMarker = pageStartMarker;
        this.updateQueryParam("page_start_marker", pageStartMarker);
        return this;
    }

    public GetPoolsSpectraS3Request withPartitionId(UUID partitionId) {
        this.partitionId = partitionId.toString();
        this.updateQueryParam("partition_id", partitionId);
        return this;
    }

    public GetPoolsSpectraS3Request withPartitionId(String partitionId) {
        this.partitionId = partitionId;
        this.updateQueryParam("partition_id", partitionId);
        return this;
    }

    public GetPoolsSpectraS3Request withPoweredOn(boolean poweredOn) {
        this.poweredOn = poweredOn;
        this.updateQueryParam("powered_on", poweredOn);
        return this;
    }

    public GetPoolsSpectraS3Request withState(PoolState state) {
        this.state = state;
        this.updateQueryParam("state", state);
        return this;
    }

    public GetPoolsSpectraS3Request withStorageDomainMemberId(UUID storageDomainMemberId) {
        this.storageDomainMemberId = storageDomainMemberId.toString();
        this.updateQueryParam("storage_domain_member_id", storageDomainMemberId);
        return this;
    }

    public GetPoolsSpectraS3Request withStorageDomainMemberId(String storageDomainMemberId) {
        this.storageDomainMemberId = storageDomainMemberId;
        this.updateQueryParam("storage_domain_member_id", storageDomainMemberId);
        return this;
    }

    public GetPoolsSpectraS3Request withType(PoolType type) {
        this.type = type;
        this.updateQueryParam("type", type);
        return this;
    }

    @Override
    public HttpVerb getVerb() {
        return HttpVerb.GET;
    }

    @Override
    public String getPath() {
        return "/_rest_/pool";
    }

    public boolean getAssignedToStorageDomain() {
        return this.assignedToStorageDomain;
    }

    public String getBucketId() {
        return this.bucketId;
    }

    public String getGuid() {
        return this.guid;
    }

    public PoolHealth getHealth() {
        return this.health;
    }

    public boolean getLastPage() {
        return this.lastPage;
    }

    public Date getLastVerified() {
        return this.lastVerified;
    }

    public String getName() {
        return this.name;
    }

    public int getPageLength() {
        return this.pageLength;
    }

    public int getPageOffset() {
        return this.pageOffset;
    }

    public String getPageStartMarker() {
        return this.pageStartMarker;
    }

    public String getPartitionId() {
        return this.partitionId;
    }

    public boolean getPoweredOn() {
        return this.poweredOn;
    }

    public PoolState getState() {
        return this.state;
    }

    public String getStorageDomainMemberId() {
        return this.storageDomainMemberId;
    }

    public PoolType getType() {
        return this.type;
    }
}

