/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.spectrads3;

import com.spectralogic.ds3client.commands.interfaces.AbstractRequest;
import com.spectralogic.ds3client.models.Priority;
import com.spectralogic.ds3client.networking.HttpVerb;
import java.util.Date;
import java.util.UUID;

public class ModifyActiveJobSpectraS3Request
extends AbstractRequest {
    private final String activeJobId;
    private Date createdAt;
    private boolean deadJobCleanupAllowed;
    private String name;
    private Priority priority;
    private boolean protectedFlag;

    public ModifyActiveJobSpectraS3Request(UUID activeJobId) {
        this.activeJobId = activeJobId.toString();
    }

    public ModifyActiveJobSpectraS3Request(String activeJobId) {
        this.activeJobId = activeJobId;
    }

    public ModifyActiveJobSpectraS3Request withCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
        this.updateQueryParam("created_at", createdAt);
        return this;
    }

    public ModifyActiveJobSpectraS3Request withDeadJobCleanupAllowed(boolean deadJobCleanupAllowed) {
        this.deadJobCleanupAllowed = deadJobCleanupAllowed;
        this.updateQueryParam("dead_job_cleanup_allowed", deadJobCleanupAllowed);
        return this;
    }

    public ModifyActiveJobSpectraS3Request withName(String name) {
        this.name = name;
        this.updateQueryParam("name", name);
        return this;
    }

    public ModifyActiveJobSpectraS3Request withPriority(Priority priority) {
        this.priority = priority;
        this.updateQueryParam("priority", priority);
        return this;
    }

    public ModifyActiveJobSpectraS3Request withProtected(boolean protectedFlag) {
        this.protectedFlag = protectedFlag;
        this.updateQueryParam("protected", protectedFlag);
        return this;
    }

    @Override
    public HttpVerb getVerb() {
        return HttpVerb.PUT;
    }

    @Override
    public String getPath() {
        return "/_rest_/active_job/" + this.activeJobId;
    }

    public String getActiveJobId() {
        return this.activeJobId;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public boolean getDeadJobCleanupAllowed() {
        return this.deadJobCleanupAllowed;
    }

    public String getName() {
        return this.name;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public boolean getProtected() {
        return this.protectedFlag;
    }
}

