/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.spectrads3;

import com.spectralogic.ds3client.commands.interfaces.AbstractRequest;
import com.spectralogic.ds3client.networking.HttpVerb;

public class ModifyCacheFilesystemSpectraS3Request
extends AbstractRequest {
    private final String cacheFilesystem;
    private double autoReclaimInitiateThreshold;
    private double autoReclaimTerminateThreshold;
    private double burstThreshold;
    private boolean cacheSafetyEnabled;
    private Long maxCapacityInBytes;
    private boolean needsReconcile;

    public ModifyCacheFilesystemSpectraS3Request(String cacheFilesystem) {
        this.cacheFilesystem = cacheFilesystem;
    }

    public ModifyCacheFilesystemSpectraS3Request withAutoReclaimInitiateThreshold(double autoReclaimInitiateThreshold) {
        this.autoReclaimInitiateThreshold = autoReclaimInitiateThreshold;
        this.updateQueryParam("auto_reclaim_initiate_threshold", autoReclaimInitiateThreshold);
        return this;
    }

    public ModifyCacheFilesystemSpectraS3Request withAutoReclaimTerminateThreshold(double autoReclaimTerminateThreshold) {
        this.autoReclaimTerminateThreshold = autoReclaimTerminateThreshold;
        this.updateQueryParam("auto_reclaim_terminate_threshold", autoReclaimTerminateThreshold);
        return this;
    }

    public ModifyCacheFilesystemSpectraS3Request withBurstThreshold(double burstThreshold) {
        this.burstThreshold = burstThreshold;
        this.updateQueryParam("burst_threshold", burstThreshold);
        return this;
    }

    public ModifyCacheFilesystemSpectraS3Request withCacheSafetyEnabled(boolean cacheSafetyEnabled) {
        this.cacheSafetyEnabled = cacheSafetyEnabled;
        this.updateQueryParam("cache_safety_enabled", cacheSafetyEnabled);
        return this;
    }

    public ModifyCacheFilesystemSpectraS3Request withMaxCapacityInBytes(Long maxCapacityInBytes) {
        this.maxCapacityInBytes = maxCapacityInBytes;
        this.updateQueryParam("max_capacity_in_bytes", maxCapacityInBytes);
        return this;
    }

    public ModifyCacheFilesystemSpectraS3Request withNeedsReconcile(boolean needsReconcile) {
        this.needsReconcile = needsReconcile;
        this.updateQueryParam("needs_reconcile", needsReconcile);
        return this;
    }

    @Override
    public HttpVerb getVerb() {
        return HttpVerb.PUT;
    }

    @Override
    public String getPath() {
        return "/_rest_/cache_filesystem/" + this.cacheFilesystem;
    }

    public String getCacheFilesystem() {
        return this.cacheFilesystem;
    }

    public double getAutoReclaimInitiateThreshold() {
        return this.autoReclaimInitiateThreshold;
    }

    public double getAutoReclaimTerminateThreshold() {
        return this.autoReclaimTerminateThreshold;
    }

    public double getBurstThreshold() {
        return this.burstThreshold;
    }

    public boolean getCacheSafetyEnabled() {
        return this.cacheSafetyEnabled;
    }

    public Long getMaxCapacityInBytes() {
        return this.maxCapacityInBytes;
    }

    public boolean getNeedsReconcile() {
        return this.needsReconcile;
    }
}

