/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.spectrads3;

import com.spectralogic.ds3client.commands.interfaces.AbstractRequest;
import com.spectralogic.ds3client.models.AutoInspectMode;
import com.spectralogic.ds3client.models.Priority;
import com.spectralogic.ds3client.models.UnavailableMediaUsagePolicy;
import com.spectralogic.ds3client.networking.HttpVerb;

public class ModifyDataPathBackendSpectraS3Request
extends AbstractRequest {
    private boolean activated;
    private boolean allowNewJobRequests;
    private Integer autoActivateTimeoutInMins;
    private AutoInspectMode autoInspect;
    private int cacheAvailableRetryAfterInSeconds;
    private Priority defaultVerifyDataAfterImport;
    private boolean defaultVerifyDataPriorToImport;
    private double iomCacheLimitationPercent;
    private boolean iomEnabled;
    private int maxAggregatedBlobsPerChunk;
    private Integer partiallyVerifyLastPercentOfTapes;
    private boolean poolSafetyEnabled;
    private UnavailableMediaUsagePolicy unavailableMediaPolicy;
    private int unavailablePoolMaxJobRetryInMins;
    private int unavailableTapePartitionMaxJobRetryInMins;
    private boolean verifyCheckpointBeforeRead;

    public ModifyDataPathBackendSpectraS3Request withActivated(boolean activated) {
        this.activated = activated;
        this.updateQueryParam("activated", activated);
        return this;
    }

    public ModifyDataPathBackendSpectraS3Request withAllowNewJobRequests(boolean allowNewJobRequests) {
        this.allowNewJobRequests = allowNewJobRequests;
        this.updateQueryParam("allow_new_job_requests", allowNewJobRequests);
        return this;
    }

    public ModifyDataPathBackendSpectraS3Request withAutoActivateTimeoutInMins(Integer autoActivateTimeoutInMins) {
        this.autoActivateTimeoutInMins = autoActivateTimeoutInMins;
        this.updateQueryParam("auto_activate_timeout_in_mins", autoActivateTimeoutInMins);
        return this;
    }

    public ModifyDataPathBackendSpectraS3Request withAutoInspect(AutoInspectMode autoInspect) {
        this.autoInspect = autoInspect;
        this.updateQueryParam("auto_inspect", autoInspect);
        return this;
    }

    public ModifyDataPathBackendSpectraS3Request withCacheAvailableRetryAfterInSeconds(int cacheAvailableRetryAfterInSeconds) {
        this.cacheAvailableRetryAfterInSeconds = cacheAvailableRetryAfterInSeconds;
        this.updateQueryParam("cache_available_retry_after_in_seconds", cacheAvailableRetryAfterInSeconds);
        return this;
    }

    public ModifyDataPathBackendSpectraS3Request withDefaultVerifyDataAfterImport(Priority defaultVerifyDataAfterImport) {
        this.defaultVerifyDataAfterImport = defaultVerifyDataAfterImport;
        this.updateQueryParam("default_verify_data_after_import", defaultVerifyDataAfterImport);
        return this;
    }

    public ModifyDataPathBackendSpectraS3Request withDefaultVerifyDataPriorToImport(boolean defaultVerifyDataPriorToImport) {
        this.defaultVerifyDataPriorToImport = defaultVerifyDataPriorToImport;
        this.updateQueryParam("default_verify_data_prior_to_import", defaultVerifyDataPriorToImport);
        return this;
    }

    public ModifyDataPathBackendSpectraS3Request withIomCacheLimitationPercent(double iomCacheLimitationPercent) {
        this.iomCacheLimitationPercent = iomCacheLimitationPercent;
        this.updateQueryParam("iom_cache_limitation_percent", iomCacheLimitationPercent);
        return this;
    }

    public ModifyDataPathBackendSpectraS3Request withIomEnabled(boolean iomEnabled) {
        this.iomEnabled = iomEnabled;
        this.updateQueryParam("iom_enabled", iomEnabled);
        return this;
    }

    public ModifyDataPathBackendSpectraS3Request withMaxAggregatedBlobsPerChunk(int maxAggregatedBlobsPerChunk) {
        this.maxAggregatedBlobsPerChunk = maxAggregatedBlobsPerChunk;
        this.updateQueryParam("max_aggregated_blobs_per_chunk", maxAggregatedBlobsPerChunk);
        return this;
    }

    public ModifyDataPathBackendSpectraS3Request withPartiallyVerifyLastPercentOfTapes(Integer partiallyVerifyLastPercentOfTapes) {
        this.partiallyVerifyLastPercentOfTapes = partiallyVerifyLastPercentOfTapes;
        this.updateQueryParam("partially_verify_last_percent_of_tapes", partiallyVerifyLastPercentOfTapes);
        return this;
    }

    public ModifyDataPathBackendSpectraS3Request withPoolSafetyEnabled(boolean poolSafetyEnabled) {
        this.poolSafetyEnabled = poolSafetyEnabled;
        this.updateQueryParam("pool_safety_enabled", poolSafetyEnabled);
        return this;
    }

    public ModifyDataPathBackendSpectraS3Request withUnavailableMediaPolicy(UnavailableMediaUsagePolicy unavailableMediaPolicy) {
        this.unavailableMediaPolicy = unavailableMediaPolicy;
        this.updateQueryParam("unavailable_media_policy", unavailableMediaPolicy);
        return this;
    }

    public ModifyDataPathBackendSpectraS3Request withUnavailablePoolMaxJobRetryInMins(int unavailablePoolMaxJobRetryInMins) {
        this.unavailablePoolMaxJobRetryInMins = unavailablePoolMaxJobRetryInMins;
        this.updateQueryParam("unavailable_pool_max_job_retry_in_mins", unavailablePoolMaxJobRetryInMins);
        return this;
    }

    public ModifyDataPathBackendSpectraS3Request withUnavailableTapePartitionMaxJobRetryInMins(int unavailableTapePartitionMaxJobRetryInMins) {
        this.unavailableTapePartitionMaxJobRetryInMins = unavailableTapePartitionMaxJobRetryInMins;
        this.updateQueryParam("unavailable_tape_partition_max_job_retry_in_mins", unavailableTapePartitionMaxJobRetryInMins);
        return this;
    }

    public ModifyDataPathBackendSpectraS3Request withVerifyCheckpointBeforeRead(boolean verifyCheckpointBeforeRead) {
        this.verifyCheckpointBeforeRead = verifyCheckpointBeforeRead;
        this.updateQueryParam("verify_checkpoint_before_read", verifyCheckpointBeforeRead);
        return this;
    }

    @Override
    public HttpVerb getVerb() {
        return HttpVerb.PUT;
    }

    @Override
    public String getPath() {
        return "/_rest_/data_path_backend";
    }

    public boolean getActivated() {
        return this.activated;
    }

    public boolean getAllowNewJobRequests() {
        return this.allowNewJobRequests;
    }

    public Integer getAutoActivateTimeoutInMins() {
        return this.autoActivateTimeoutInMins;
    }

    public AutoInspectMode getAutoInspect() {
        return this.autoInspect;
    }

    public int getCacheAvailableRetryAfterInSeconds() {
        return this.cacheAvailableRetryAfterInSeconds;
    }

    public Priority getDefaultVerifyDataAfterImport() {
        return this.defaultVerifyDataAfterImport;
    }

    public boolean getDefaultVerifyDataPriorToImport() {
        return this.defaultVerifyDataPriorToImport;
    }

    public double getIomCacheLimitationPercent() {
        return this.iomCacheLimitationPercent;
    }

    public boolean getIomEnabled() {
        return this.iomEnabled;
    }

    public int getMaxAggregatedBlobsPerChunk() {
        return this.maxAggregatedBlobsPerChunk;
    }

    public Integer getPartiallyVerifyLastPercentOfTapes() {
        return this.partiallyVerifyLastPercentOfTapes;
    }

    public boolean getPoolSafetyEnabled() {
        return this.poolSafetyEnabled;
    }

    public UnavailableMediaUsagePolicy getUnavailableMediaPolicy() {
        return this.unavailableMediaPolicy;
    }

    public int getUnavailablePoolMaxJobRetryInMins() {
        return this.unavailablePoolMaxJobRetryInMins;
    }

    public int getUnavailableTapePartitionMaxJobRetryInMins() {
        return this.unavailableTapePartitionMaxJobRetryInMins;
    }

    public boolean getVerifyCheckpointBeforeRead() {
        return this.verifyCheckpointBeforeRead;
    }
}

