/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.spectrads3;

import com.spectralogic.ds3client.commands.interfaces.AbstractRequest;
import com.spectralogic.ds3client.models.Priority;
import com.spectralogic.ds3client.networking.HttpVerb;
import java.util.Date;
import java.util.UUID;

public class ModifyJobSpectraS3Request
extends AbstractRequest {
    private final String jobId;
    private Date createdAt;
    private boolean deadJobCleanupAllowed;
    private String name;
    private Priority priority;
    private boolean protectedFlag;

    public ModifyJobSpectraS3Request(UUID jobId) {
        this.jobId = jobId.toString();
    }

    public ModifyJobSpectraS3Request(String jobId) {
        this.jobId = jobId;
    }

    public ModifyJobSpectraS3Request withCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
        this.updateQueryParam("created_at", createdAt);
        return this;
    }

    public ModifyJobSpectraS3Request withDeadJobCleanupAllowed(boolean deadJobCleanupAllowed) {
        this.deadJobCleanupAllowed = deadJobCleanupAllowed;
        this.updateQueryParam("dead_job_cleanup_allowed", deadJobCleanupAllowed);
        return this;
    }

    public ModifyJobSpectraS3Request withName(String name) {
        this.name = name;
        this.updateQueryParam("name", name);
        return this;
    }

    public ModifyJobSpectraS3Request withPriority(Priority priority) {
        this.priority = priority;
        this.updateQueryParam("priority", priority);
        return this;
    }

    public ModifyJobSpectraS3Request withProtected(boolean protectedFlag) {
        this.protectedFlag = protectedFlag;
        this.updateQueryParam("protected", protectedFlag);
        return this;
    }

    @Override
    public HttpVerb getVerb() {
        return HttpVerb.PUT;
    }

    @Override
    public String getPath() {
        return "/_rest_/job/" + this.jobId;
    }

    public String getJobId() {
        return this.jobId;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public boolean getDeadJobCleanupAllowed() {
        return this.deadJobCleanupAllowed;
    }

    public String getName() {
        return this.name;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public boolean getProtected() {
        return this.protectedFlag;
    }
}

