/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.spectrads3;

import com.spectralogic.ds3client.commands.interfaces.AbstractRequest;
import com.spectralogic.ds3client.models.Quiesced;
import com.spectralogic.ds3client.networking.HttpVerb;

public class ModifyTapePartitionSpectraS3Request
extends AbstractRequest {
    private final String tapePartition;
    private boolean autoCompactionEnabled;
    private boolean autoQuiesceEnabled;
    private Integer driveIdleTimeoutInMinutes;
    private int minimumReadReservedDrives;
    private int minimumWriteReservedDrives;
    private Quiesced quiesced;
    private String serialNumber;

    public ModifyTapePartitionSpectraS3Request(String tapePartition) {
        this.tapePartition = tapePartition;
    }

    public ModifyTapePartitionSpectraS3Request withAutoCompactionEnabled(boolean autoCompactionEnabled) {
        this.autoCompactionEnabled = autoCompactionEnabled;
        this.updateQueryParam("auto_compaction_enabled", autoCompactionEnabled);
        return this;
    }

    public ModifyTapePartitionSpectraS3Request withAutoQuiesceEnabled(boolean autoQuiesceEnabled) {
        this.autoQuiesceEnabled = autoQuiesceEnabled;
        this.updateQueryParam("auto_quiesce_enabled", autoQuiesceEnabled);
        return this;
    }

    public ModifyTapePartitionSpectraS3Request withDriveIdleTimeoutInMinutes(Integer driveIdleTimeoutInMinutes) {
        this.driveIdleTimeoutInMinutes = driveIdleTimeoutInMinutes;
        this.updateQueryParam("drive_idle_timeout_in_minutes", driveIdleTimeoutInMinutes);
        return this;
    }

    public ModifyTapePartitionSpectraS3Request withMinimumReadReservedDrives(int minimumReadReservedDrives) {
        this.minimumReadReservedDrives = minimumReadReservedDrives;
        this.updateQueryParam("minimum_read_reserved_drives", minimumReadReservedDrives);
        return this;
    }

    public ModifyTapePartitionSpectraS3Request withMinimumWriteReservedDrives(int minimumWriteReservedDrives) {
        this.minimumWriteReservedDrives = minimumWriteReservedDrives;
        this.updateQueryParam("minimum_write_reserved_drives", minimumWriteReservedDrives);
        return this;
    }

    public ModifyTapePartitionSpectraS3Request withQuiesced(Quiesced quiesced) {
        this.quiesced = quiesced;
        this.updateQueryParam("quiesced", quiesced);
        return this;
    }

    public ModifyTapePartitionSpectraS3Request withSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
        this.updateQueryParam("serial_number", serialNumber);
        return this;
    }

    @Override
    public HttpVerb getVerb() {
        return HttpVerb.PUT;
    }

    @Override
    public String getPath() {
        return "/_rest_/tape_partition/" + this.tapePartition;
    }

    public String getTapePartition() {
        return this.tapePartition;
    }

    public boolean getAutoCompactionEnabled() {
        return this.autoCompactionEnabled;
    }

    public boolean getAutoQuiesceEnabled() {
        return this.autoQuiesceEnabled;
    }

    public Integer getDriveIdleTimeoutInMinutes() {
        return this.driveIdleTimeoutInMinutes;
    }

    public int getMinimumReadReservedDrives() {
        return this.minimumReadReservedDrives;
    }

    public int getMinimumWriteReservedDrives() {
        return this.minimumWriteReservedDrives;
    }

    public Quiesced getQuiesced() {
        return this.quiesced;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }
}

