/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.spectrads3;

import com.spectralogic.ds3client.commands.interfaces.AbstractRequest;
import com.spectralogic.ds3client.models.TapeRole;
import com.spectralogic.ds3client.models.TapeState;
import com.spectralogic.ds3client.networking.HttpVerb;
import java.util.UUID;

public class ModifyTapeSpectraS3Request
extends AbstractRequest {
    private final String tapeId;
    private String ejectLabel;
    private String ejectLocation;
    private TapeRole role;
    private TapeState state;

    public ModifyTapeSpectraS3Request(UUID tapeId) {
        this.tapeId = tapeId.toString();
    }

    public ModifyTapeSpectraS3Request(String tapeId) {
        this.tapeId = tapeId;
    }

    public ModifyTapeSpectraS3Request withEjectLabel(String ejectLabel) {
        this.ejectLabel = ejectLabel;
        this.updateQueryParam("eject_label", ejectLabel);
        return this;
    }

    public ModifyTapeSpectraS3Request withEjectLocation(String ejectLocation) {
        this.ejectLocation = ejectLocation;
        this.updateQueryParam("eject_location", ejectLocation);
        return this;
    }

    public ModifyTapeSpectraS3Request withRole(TapeRole role) {
        this.role = role;
        this.updateQueryParam("role", role);
        return this;
    }

    public ModifyTapeSpectraS3Request withState(TapeState state) {
        this.state = state;
        this.updateQueryParam("state", state);
        return this;
    }

    @Override
    public HttpVerb getVerb() {
        return HttpVerb.PUT;
    }

    @Override
    public String getPath() {
        return "/_rest_/tape/" + this.tapeId;
    }

    public String getTapeId() {
        return this.tapeId;
    }

    public String getEjectLabel() {
        return this.ejectLabel;
    }

    public String getEjectLocation() {
        return this.ejectLocation;
    }

    public TapeRole getRole() {
        return this.role;
    }

    public TapeState getState() {
        return this.state;
    }
}

