/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.spectrads3;

import com.spectralogic.ds3client.commands.interfaces.AbstractRequest;
import com.spectralogic.ds3client.networking.HttpVerb;
import java.util.UUID;

public class TestTapeDriveSpectraS3Request
extends AbstractRequest {
    private final String tapeDriveId;
    private boolean skipClean;
    private String tapeId;

    public TestTapeDriveSpectraS3Request(UUID tapeDriveId) {
        this.tapeDriveId = tapeDriveId.toString();
        this.getQueryParams().put("operation", "test");
    }

    public TestTapeDriveSpectraS3Request(String tapeDriveId) {
        this.tapeDriveId = tapeDriveId;
        this.getQueryParams().put("operation", "test");
    }

    public TestTapeDriveSpectraS3Request withSkipClean(boolean skipClean) {
        this.skipClean = skipClean;
        if (this.skipClean) {
            this.getQueryParams().put("skip_clean", null);
        } else {
            this.getQueryParams().remove("skip_clean");
        }
        return this;
    }

    public TestTapeDriveSpectraS3Request withTapeId(UUID tapeId) {
        this.tapeId = tapeId.toString();
        this.updateQueryParam("tape_id", tapeId);
        return this;
    }

    public TestTapeDriveSpectraS3Request withTapeId(String tapeId) {
        this.tapeId = tapeId;
        this.updateQueryParam("tape_id", tapeId);
        return this;
    }

    @Override
    public HttpVerb getVerb() {
        return HttpVerb.PUT;
    }

    @Override
    public String getPath() {
        return "/_rest_/tape_drive/" + this.tapeDriveId;
    }

    public String getTapeDriveId() {
        return this.tapeDriveId;
    }

    public boolean getSkipClean() {
        return this.skipClean;
    }

    public String getTapeId() {
        return this.tapeId;
    }
}

