/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.helpers;

import com.spectralogic.ds3client.Ds3Client;
import com.spectralogic.ds3client.commands.DeleteBucketRequest;
import com.spectralogic.ds3client.commands.DeleteObjectsRequest;
import com.spectralogic.ds3client.helpers.Ds3ClientHelpers;
import com.spectralogic.ds3client.models.Contents;
import com.spectralogic.ds3client.utils.collections.IterableExtensionsKt;
import com.spectralogic.ds3client.utils.collections.WindowedIteratorKt;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\n"}, d2={"Lcom/spectralogic/ds3client/helpers/DeleteBucket;", "", "()V", "deleteBucket", "", "helpers", "Lcom/spectralogic/ds3client/helpers/Ds3ClientHelpers;", "bucket", "", "deleteBucketContents", "ds3-sdk"})
public final class DeleteBucket {
    @NotNull
    public static final DeleteBucket INSTANCE = new DeleteBucket();

    private DeleteBucket() {
    }

    public final void deleteBucket(@NotNull Ds3ClientHelpers helpers, @NotNull String bucket) {
        Intrinsics.checkNotNullParameter((Object)helpers, (String)"helpers");
        Intrinsics.checkNotNullParameter((Object)bucket, (String)"bucket");
        this.deleteBucketContents(helpers, bucket);
        helpers.getClient().deleteBucket(new DeleteBucketRequest(bucket));
    }

    public final void deleteBucketContents(@NotNull Ds3ClientHelpers helpers, @NotNull String bucket) {
        Intrinsics.checkNotNullParameter((Object)helpers, (String)"helpers");
        Intrinsics.checkNotNullParameter((Object)bucket, (String)"bucket");
        Ds3Client client = helpers.getClient();
        Iterator<Contents> objIterator = helpers.listObjects(bucket).iterator();
        while (objIterator.hasNext()) {
            Iterator<Contents> subIterator = WindowedIteratorKt.take(objIterator, 1000);
            client.deleteObjects(new DeleteObjectsRequest(bucket, IterableExtensionsKt.asIterable(subIterator)));
        }
    }
}

