/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.helpers;

import com.spectralogic.ds3client.helpers.ChecksumListener;
import com.spectralogic.ds3client.helpers.DataTransferredListener;
import com.spectralogic.ds3client.helpers.Ds3ClientHelpers;
import com.spectralogic.ds3client.helpers.FailureEventListener;
import com.spectralogic.ds3client.helpers.ObjectCompletedListener;
import com.spectralogic.ds3client.helpers.WaitingForChunksListener;
import com.spectralogic.ds3client.helpers.strategy.transferstrategy.CanceledEventObserver;
import com.spectralogic.ds3client.helpers.strategy.transferstrategy.EventDispatcher;
import com.spectralogic.ds3client.helpers.strategy.transferstrategy.TransferStrategy;
import com.spectralogic.ds3client.helpers.strategy.transferstrategy.TransferStrategyBuilder;
import java.io.IOException;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class JobImpl
implements Ds3ClientHelpers.Job {
    private static final Logger LOG = LoggerFactory.getLogger(JobImpl.class);
    protected boolean running = false;
    private final TransferStrategyBuilder transferStrategyBuilder;

    public JobImpl() {
        this(null);
    }

    public JobImpl(TransferStrategyBuilder transferStrategyBuilder) {
        this.transferStrategyBuilder = transferStrategyBuilder;
    }

    @Override
    public UUID getJobId() {
        try {
            return this.transferStrategyBuilder.masterObjectList().getJobId();
        }
        catch (Throwable t) {
            LOG.warn("Could not get job id.", t);
            return null;
        }
    }

    @Override
    public String getBucketName() {
        try {
            return this.transferStrategyBuilder.masterObjectList().getBucketName();
        }
        catch (Throwable t) {
            LOG.warn("Could not get bucket name.", t);
            return null;
        }
    }

    @Override
    public Ds3ClientHelpers.Job withMaxParallelRequests(int maxParallelRequests) {
        this.transferStrategyBuilder.withNumConcurrentTransferThreads(maxParallelRequests);
        return this;
    }

    protected void checkRunning() {
        if (this.running) {
            throw new IllegalStateException("You cannot modify a job after calling transfer");
        }
    }

    @Override
    public void attachChecksumListener(ChecksumListener listener) {
        this.checkRunning();
        this.eventDispatcher().attachChecksumListener(listener);
    }

    @Override
    public void removeChecksumListener(ChecksumListener listener) {
        this.checkRunning();
        this.eventDispatcher().removeChecksumListener(listener);
    }

    @Override
    public void attachWaitingForChunksListener(WaitingForChunksListener listener) {
        this.checkRunning();
        this.eventDispatcher().attachWaitingForChunksListener(listener);
    }

    @Override
    public void removeWaitingForChunksListener(WaitingForChunksListener listener) {
        this.checkRunning();
        this.eventDispatcher().removeWaitingForChunksListener(listener);
    }

    @Override
    public void attachFailureEventListener(FailureEventListener listener) {
        this.checkRunning();
        this.eventDispatcher().attachFailureEventListener(listener);
    }

    @Override
    public void removeFailureEventListener(FailureEventListener listener) {
        this.checkRunning();
        this.eventDispatcher().removeFailureEventListener(listener);
    }

    @Override
    public void attachDataTransferredListener(DataTransferredListener listener) {
        this.checkRunning();
        this.eventDispatcher().attachDataTransferredListener(listener);
    }

    @Override
    public void removeDataTransferredListener(DataTransferredListener listener) {
        this.checkRunning();
        this.eventDispatcher().removeDataTransferredListener(listener);
    }

    @Override
    public void attachObjectCompletedListener(ObjectCompletedListener listener) {
        this.checkRunning();
        this.eventDispatcher().attachObjectCompletedListener(listener);
    }

    @Override
    public void removeObjectCompletedListener(ObjectCompletedListener listener) {
        this.checkRunning();
        this.eventDispatcher().removeObjectCompletedListener(listener);
    }

    @Override
    public CanceledEventObserver attachCanceledEventObserver(CanceledEventObserver canceledEventObserver) {
        this.checkRunning();
        return this.eventDispatcher().attachCanceledEventObserver(canceledEventObserver);
    }

    @Override
    public void removeCanceledEventObserver(CanceledEventObserver canceledEventObserver) {
        this.checkRunning();
        this.eventDispatcher().removeCanceledEventObserver(canceledEventObserver);
    }

    @Override
    public void transfer(Ds3ClientHelpers.ObjectChannelBuilder channelBuilder) throws IOException {
        this.transferStrategyBuilder.withChannelBuilder(channelBuilder);
    }

    protected TransferStrategyBuilder transferStrategyBuilder() {
        return this.transferStrategyBuilder;
    }

    protected EventDispatcher eventDispatcher() {
        return this.transferStrategyBuilder.eventDispatcher();
    }

    protected static void cancel(TransferStrategy transferStrategy) throws IOException {
        if (transferStrategy != null) {
            transferStrategy.cancel();
        }
    }
}

