/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.helpers;

import com.google.common.collect.Sets;
import com.spectralogic.ds3client.helpers.DataTransferredListener;
import com.spectralogic.ds3client.helpers.ObjectCompletedListener;
import com.spectralogic.ds3client.helpers.ObjectPart;
import com.spectralogic.ds3client.helpers.ObjectPartComparator;
import com.spectralogic.ds3client.helpers.ObjectPartTracker;
import com.spectralogic.ds3client.helpers.events.EventRunner;
import java.security.InvalidParameterException;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;

class ObjectPartTrackerImpl
implements ObjectPartTracker {
    private final String name;
    private final TreeSet<ObjectPart> parts;
    private final Set<DataTransferredListener> dataTransferredListeners = Sets.newIdentityHashSet();
    private final Set<ObjectCompletedListener> objectCompletedListeners = Sets.newIdentityHashSet();
    private final EventRunner eventRunner;

    public ObjectPartTrackerImpl(String name, Collection<ObjectPart> parts, EventRunner eventRunner) {
        this.name = name;
        this.parts = new TreeSet<ObjectPart>(ObjectPartComparator.instance());
        this.parts.addAll(parts);
        this.eventRunner = eventRunner;
        this.validateParts();
    }

    @Override
    public synchronized ObjectPartTracker attachDataTransferredListener(DataTransferredListener listener) {
        this.dataTransferredListeners.add(listener);
        return this;
    }

    @Override
    public synchronized ObjectPartTracker attachObjectCompletedListener(ObjectCompletedListener listener) {
        this.objectCompletedListeners.add(listener);
        return this;
    }

    @Override
    public void removeDataTransferredListener(DataTransferredListener listener) {
        this.dataTransferredListeners.remove(listener);
    }

    @Override
    public void removeObjectCompletedListener(ObjectCompletedListener listener) {
        this.objectCompletedListeners.remove(listener);
    }

    @Override
    public synchronized void completePart(ObjectPart part) {
        ObjectPart existingPart = this.parts.floor(part);
        if (existingPart == null) {
            throw new IllegalStateException("The object part was not available to be marked completed.");
        }
        if (part.getEnd() > existingPart.getEnd()) {
            throw new IllegalStateException("The object part was not available to be marked completed.");
        }
        this.parts.remove(existingPart);
        if (part.getOffset() > existingPart.getOffset()) {
            this.parts.add(new ObjectPart(existingPart.getOffset(), part.getOffset() - existingPart.getOffset()));
        }
        if (part.getEnd() < existingPart.getEnd()) {
            this.parts.add(new ObjectPart(part.getEnd() + 1L, existingPart.getEnd() - part.getEnd()));
        }
        this.onDataTransferred(part.getLength());
        if (this.parts.size() == 0) {
            this.onObjectCompleted();
        }
    }

    @Override
    public synchronized boolean containsPart(ObjectPart part) {
        ObjectPart existingPart = this.parts.ceiling(part);
        return existingPart != null && existingPart.getLength() == part.getLength();
    }

    private synchronized void validateParts() {
        long lastEnd = -1L;
        for (ObjectPart part : this.parts) {
            if (part.getOffset() <= lastEnd) {
                throw new InvalidParameterException();
            }
            lastEnd = part.getEnd();
        }
    }

    private void onDataTransferred(long size) {
        for (DataTransferredListener listener : this.dataTransferredListeners) {
            this.eventRunner.emitEvent(new DataTransferredRunnable(listener, size));
        }
    }

    private void onObjectCompleted() {
        for (ObjectCompletedListener listener : this.objectCompletedListeners) {
            this.eventRunner.emitEvent(new ObjectCompletedRunnable(listener, this.name));
        }
    }

    private static class DataTransferredRunnable
    implements Runnable {
        private final DataTransferredListener listener;
        private final long size;

        public DataTransferredRunnable(DataTransferredListener listener, long size) {
            this.listener = listener;
            this.size = size;
        }

        @Override
        public void run() {
            this.listener.dataTransferred(this.size);
        }
    }

    private static class ObjectCompletedRunnable
    implements Runnable {
        private final ObjectCompletedListener listener;
        private final String name;

        public ObjectCompletedRunnable(ObjectCompletedListener listener, String name) {
            this.listener = listener;
            this.name = name;
        }

        @Override
        public void run() {
            this.listener.objectCompleted(this.name);
        }
    }
}

