/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.helpers.pagination;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.spectralogic.ds3client.Ds3Client;
import com.spectralogic.ds3client.helpers.pagination.FileSystemKey;
import com.spectralogic.ds3client.helpers.pagination.GetBucketKeyLoader;
import com.spectralogic.ds3client.models.Contents;
import com.spectralogic.ds3client.models.ListBucketResult;
import com.spectralogic.ds3client.models.common.CommonPrefixes;
import com.spectralogic.ds3client.utils.collections.LazyIterable;
import javax.annotation.Nullable;

public class GetBucketKeyLoaderFactory<T>
implements LazyIterable.LazyLoaderFactory<T> {
    public static final Function<ListBucketResult, Iterable<Contents>> contentsFunction = new Function<ListBucketResult, Iterable<Contents>>(){

        public Iterable<Contents> apply(@Nullable ListBucketResult input) {
            return input.getObjects();
        }
    };
    public static final Function<ListBucketResult, Iterable<FileSystemKey>> getFileSystemKeysFunction = new Function<ListBucketResult, Iterable<FileSystemKey>>(){

        @Nullable
        public Iterable<FileSystemKey> apply(@Nullable ListBucketResult result) {
            FluentIterable contentIterable = FluentIterable.from(result.getObjects()).transform((Function)new ContentsFileSystemKeyFunction());
            return FluentIterable.from(result.getCommonPrefixes()).transform((Function)new CommonPrefixesFileSystemKeyFunction()).append((Iterable)contentIterable);
        }
    };
    private final Ds3Client client;
    private final String bucket;
    private final String keyPrefix;
    private final String nextMarker;
    private final String delimiter;
    private final int maxKeys;
    private final int defaultListObjectsRetries;
    private final Function<ListBucketResult, Iterable<T>> function;

    public GetBucketKeyLoaderFactory(Ds3Client client, String bucket, String keyPrefix, String delimiter, String nextMarker, int maxKeys, int defaultListObjectsRetries, Function<ListBucketResult, Iterable<T>> function) {
        this.client = client;
        this.bucket = bucket;
        this.keyPrefix = keyPrefix;
        this.delimiter = delimiter;
        this.nextMarker = nextMarker;
        this.maxKeys = maxKeys;
        this.defaultListObjectsRetries = defaultListObjectsRetries;
        this.function = function;
    }

    @Override
    public LazyIterable.LazyLoader<T> create() {
        return new GetBucketKeyLoader<T>(this.client, this.bucket, this.keyPrefix, this.delimiter, this.nextMarker, this.maxKeys, this.defaultListObjectsRetries, this.function);
    }

    private static class CommonPrefixesFileSystemKeyFunction
    implements Function<CommonPrefixes, FileSystemKey> {
        private CommonPrefixesFileSystemKeyFunction() {
        }

        public FileSystemKey apply(@Nullable CommonPrefixes input) {
            return new FileSystemKey(input);
        }
    }

    private static class ContentsFileSystemKeyFunction
    implements Function<Contents, FileSystemKey> {
        private ContentsFileSystemKeyFunction() {
        }

        public FileSystemKey apply(@Nullable Contents input) {
            return new FileSystemKey(input);
        }
    }
}

