/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.helpers.strategy.transferstrategy;

import com.google.common.base.Preconditions;
import com.spectralogic.ds3client.helpers.ChecksumListener;
import com.spectralogic.ds3client.helpers.strategy.transferstrategy.AbstractObserver;
import com.spectralogic.ds3client.helpers.strategy.transferstrategy.ChecksumEvent;
import com.spectralogic.ds3client.helpers.strategy.transferstrategy.UpdateStrategy;

public class ChecksumObserver
extends AbstractObserver<ChecksumEvent> {
    public ChecksumObserver(ChecksumListener checksumListener) {
        super(new ChecksumEventUpdateStrategy(checksumListener));
        Preconditions.checkNotNull((Object)checksumListener, (Object)"checksumListener may not be null.");
    }

    public ChecksumObserver(UpdateStrategy<ChecksumEvent> updateStrategy) {
        super(updateStrategy);
    }

    private static class ChecksumEventUpdateStrategy
    implements UpdateStrategy<ChecksumEvent> {
        private final ChecksumListener checksumListener;

        public ChecksumEventUpdateStrategy(ChecksumListener checksumListener) {
            this.checksumListener = checksumListener;
        }

        @Override
        public void update(ChecksumEvent eventData) {
            this.checksumListener.value(eventData.getBlob(), eventData.getChecksumType(), eventData.getChecksum());
        }
    }
}

