/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.helpers.strategy.transferstrategy;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.spectralogic.ds3client.exceptions.ContentLengthNotMatchException;
import com.spectralogic.ds3client.helpers.JobPart;
import com.spectralogic.ds3client.helpers.RecoverableIOException;
import com.spectralogic.ds3client.helpers.strategy.StrategyUtils;
import com.spectralogic.ds3client.helpers.strategy.channelstrategy.ChannelStrategy;
import com.spectralogic.ds3client.helpers.strategy.transferstrategy.EventDispatcher;
import com.spectralogic.ds3client.helpers.strategy.transferstrategy.GetJobPartialBlobTransferMethod;
import com.spectralogic.ds3client.helpers.strategy.transferstrategy.GetJobTransferMethod;
import com.spectralogic.ds3client.helpers.strategy.transferstrategy.RangeHelper;
import com.spectralogic.ds3client.helpers.strategy.transferstrategy.TransferMethod;
import com.spectralogic.ds3client.models.BulkObject;
import com.spectralogic.ds3client.models.common.Range;
import com.spectralogic.ds3client.utils.Guard;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class GetJobNetworkFailureRetryDecorator
implements TransferMethod {
    private final ChannelStrategy channelStrategy;
    private final String bucketName;
    private final String jobId;
    private final EventDispatcher eventDispatcher;
    private final ImmutableMap<String, ImmutableMultimap<BulkObject, Range>> rangesForBlobs;
    private final Map<JobPart, TransferState> transferMethodMap = new HashMap<JobPart, TransferState>();

    public GetJobNetworkFailureRetryDecorator(ChannelStrategy channelStrategy, String bucketName, String jobId, EventDispatcher eventDispatcher, ImmutableMap<String, ImmutableMultimap<BulkObject, Range>> rangesForBlobs) {
        this.channelStrategy = channelStrategy;
        this.bucketName = bucketName;
        this.jobId = jobId;
        this.eventDispatcher = eventDispatcher;
        this.rangesForBlobs = rangesForBlobs;
    }

    @Override
    public void transferJobPart(JobPart jobPart) throws IOException {
        try {
            this.getOrMakeTransferMethod(jobPart).transferJobPart(jobPart);
        }
        catch (ContentLengthNotMatchException contentLengthNotMatchException) {
            this.makeTransferMethodForPartialRetry(jobPart, contentLengthNotMatchException.getTotalBytes());
            throw new RecoverableIOException(contentLengthNotMatchException);
        }
    }

    private synchronized TransferMethod getOrMakeTransferMethod(JobPart jobPart) {
        TransferState transferState = this.transferMethodMap.get(jobPart);
        if (transferState != null) {
            return transferState.getTransferMethod();
        }
        transferState = this.makeInitialTransferState();
        this.transferMethodMap.put(jobPart, transferState);
        return transferState.getTransferMethod();
    }

    private TransferState makeInitialTransferState() {
        ImmutableCollection ranges = null;
        Long numBytesToTransfer = null;
        long destinationChannelOffset = 0L;
        return new TransferState(ranges, numBytesToTransfer, 0L, new GetJobTransferMethod(this.channelStrategy, this.bucketName, this.jobId, this.eventDispatcher, this.rangesForBlobs));
    }

    private synchronized void makeTransferMethodForPartialRetry(JobPart jobPart, long numBytesTransferred) {
        TransferState existingTransferState = this.transferMethodMap.get(jobPart);
        ImmutableCollection<Range> ranges = this.initializeRanges(jobPart.getBlob(), existingTransferState);
        Long numBytesToTransfer = GetJobNetworkFailureRetryDecorator.initializeNumBytesToTransfer(existingTransferState, ranges);
        ranges = GetJobNetworkFailureRetryDecorator.updateRanges(ranges, numBytesTransferred, numBytesToTransfer);
        long destinationChannelOffset = existingTransferState.getDestinationChannelOffset() + numBytesTransferred;
        TransferState newTransferState = new TransferState(ranges, numBytesToTransfer, destinationChannelOffset, new GetJobPartialBlobTransferMethod(this.channelStrategy, this.bucketName, this.jobId, this.eventDispatcher, ranges, destinationChannelOffset));
        this.transferMethodMap.put(jobPart, newTransferState);
    }

    private ImmutableCollection<Range> initializeRanges(BulkObject blob, TransferState existingTransferState) {
        ImmutableCollection<Range> ranges = existingTransferState.getRanges();
        if (ranges == null) {
            ranges = StrategyUtils.getRangesForBlob(this.rangesForBlobs, blob);
        }
        if (ranges == null) {
            long numBytesTransferred = 0L;
            ranges = GetJobNetworkFailureRetryDecorator.adjustRangesForBlobOffset(GetJobNetworkFailureRetryDecorator.updateRanges(ranges, 0L, blob.getLength()), blob);
        }
        return ranges;
    }

    private static ImmutableCollection<Range> adjustRangesForBlobOffset(ImmutableCollection<Range> ranges, BulkObject blob) {
        if (Guard.isNullOrEmpty(ranges) || ranges.size() > 1) {
            return ranges;
        }
        Range firstRange = (Range)ranges.iterator().next();
        long blobOffset = blob.getOffset();
        return ImmutableList.of((Object)new Range(firstRange.getStart() + blobOffset, firstRange.getEnd() + blobOffset));
    }

    private static ImmutableCollection<Range> updateRanges(ImmutableCollection<Range> ranges, long numBytesTransferred, Long numBytesToTransfer) {
        return RangeHelper.replaceRange(ranges, numBytesTransferred, numBytesToTransfer);
    }

    private static Long initializeNumBytesToTransfer(TransferState existingTransferState, ImmutableCollection<Range> ranges) {
        Long numBytesToTransfer = existingTransferState.getNumBytesToTransfer();
        if (numBytesToTransfer == null) {
            numBytesToTransfer = RangeHelper.transferSizeForRanges(ranges);
        }
        return numBytesToTransfer;
    }

    private static class TransferState {
        private final ImmutableCollection<Range> ranges;
        private final Long numBytesToTransfer;
        private final Long destinationChannelOffset;
        private final TransferMethod transferMethod;

        private TransferState(ImmutableCollection<Range> ranges, Long numBytesToTransfer, Long destinationChannelOffset, TransferMethod transferMethod) {
            this.ranges = ranges;
            this.numBytesToTransfer = numBytesToTransfer;
            this.destinationChannelOffset = destinationChannelOffset;
            this.transferMethod = transferMethod;
        }

        public ImmutableCollection<Range> getRanges() {
            return this.ranges;
        }

        public Long getNumBytesToTransfer() {
            return this.numBytesToTransfer;
        }

        public Long getDestinationChannelOffset() {
            return this.destinationChannelOffset;
        }

        public TransferMethod getTransferMethod() {
            return this.transferMethod;
        }
    }
}

