/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.helpers.strategy.transferstrategy;

import com.google.common.base.Preconditions;
import com.spectralogic.ds3client.helpers.MetadataReceivedListener;
import com.spectralogic.ds3client.helpers.events.MetadataEvent;
import com.spectralogic.ds3client.helpers.strategy.transferstrategy.AbstractObserver;
import com.spectralogic.ds3client.helpers.strategy.transferstrategy.UpdateStrategy;

public class MetaDataReceivedObserver
extends AbstractObserver<MetadataEvent> {
    private MetadataReceivedListener metadataReceivedListener;

    public MetaDataReceivedObserver(MetadataReceivedListener metadataReceivedListener) {
        super(new MetadataEventUpdateStrategy(metadataReceivedListener));
        Preconditions.checkNotNull((Object)metadataReceivedListener, (Object)"metadataReceivedListener may not be null.");
        this.metadataReceivedListener = metadataReceivedListener;
    }

    public MetaDataReceivedObserver(UpdateStrategy<MetadataEvent> updateStrategy) {
        super(updateStrategy);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MetaDataReceivedObserver)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MetaDataReceivedObserver that = (MetaDataReceivedObserver)o;
        return this.metadataReceivedListener != null ? this.metadataReceivedListener.equals(that.metadataReceivedListener) : that.metadataReceivedListener == null;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.metadataReceivedListener != null ? this.metadataReceivedListener.hashCode() : 0);
        return result;
    }

    private static class MetadataEventUpdateStrategy
    implements UpdateStrategy<MetadataEvent> {
        private final MetadataReceivedListener metadataReceivedListener;

        public MetadataEventUpdateStrategy(MetadataReceivedListener metadataReceivedListener) {
            this.metadataReceivedListener = metadataReceivedListener;
        }

        @Override
        public void update(MetadataEvent eventData) {
            this.metadataReceivedListener.metadataReceived(eventData.getObjectName(), eventData.getMetadata());
        }
    }
}

