/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.helpers.strategy.transferstrategy;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Iterables;
import com.spectralogic.ds3client.Ds3Client;
import com.spectralogic.ds3client.helpers.ChecksumFunction;
import com.spectralogic.ds3client.helpers.Ds3ClientHelpers;
import com.spectralogic.ds3client.helpers.JobPartTracker;
import com.spectralogic.ds3client.helpers.JobPartTrackerFactory;
import com.spectralogic.ds3client.helpers.JobState;
import com.spectralogic.ds3client.helpers.MetadataAccess;
import com.spectralogic.ds3client.helpers.ObjectCompletedListener;
import com.spectralogic.ds3client.helpers.ObjectPart;
import com.spectralogic.ds3client.helpers.events.EventRunner;
import com.spectralogic.ds3client.helpers.events.FailureEvent;
import com.spectralogic.ds3client.helpers.events.SameThreadEventRunner;
import com.spectralogic.ds3client.helpers.strategy.StrategyUtils;
import com.spectralogic.ds3client.helpers.strategy.blobstrategy.BlackPearlChunkAttemptRetryDelayBehavior;
import com.spectralogic.ds3client.helpers.strategy.blobstrategy.BlobStrategy;
import com.spectralogic.ds3client.helpers.strategy.blobstrategy.BlobStrategyMaker;
import com.spectralogic.ds3client.helpers.strategy.blobstrategy.ChunkAttemptRetryBehavior;
import com.spectralogic.ds3client.helpers.strategy.blobstrategy.ChunkAttemptRetryDelayBehavior;
import com.spectralogic.ds3client.helpers.strategy.blobstrategy.ClientDefinedChunkAttemptRetryDelayBehavior;
import com.spectralogic.ds3client.helpers.strategy.blobstrategy.ContinueForeverChunkAttemptsRetryBehavior;
import com.spectralogic.ds3client.helpers.strategy.blobstrategy.GetSequentialBlobStrategy;
import com.spectralogic.ds3client.helpers.strategy.blobstrategy.MaxChunkAttemptsRetryBehavior;
import com.spectralogic.ds3client.helpers.strategy.blobstrategy.PutSequentialBlobStrategy;
import com.spectralogic.ds3client.helpers.strategy.channelstrategy.ChannelStrategy;
import com.spectralogic.ds3client.helpers.strategy.channelstrategy.NullChannelPreparable;
import com.spectralogic.ds3client.helpers.strategy.channelstrategy.RandomAccessChannelStrategy;
import com.spectralogic.ds3client.helpers.strategy.channelstrategy.SequentialChannelStrategy;
import com.spectralogic.ds3client.helpers.strategy.channelstrategy.SequentialFileReaderChannelStrategy;
import com.spectralogic.ds3client.helpers.strategy.channelstrategy.SequentialFileWriterChannelStrategy;
import com.spectralogic.ds3client.helpers.strategy.channelstrategy.TruncatingChannelPreparable;
import com.spectralogic.ds3client.helpers.strategy.transferstrategy.BlobTransferredEventObserver;
import com.spectralogic.ds3client.helpers.strategy.transferstrategy.ContinueForeverTransferRetryDecorator;
import com.spectralogic.ds3client.helpers.strategy.transferstrategy.EventDispatcher;
import com.spectralogic.ds3client.helpers.strategy.transferstrategy.EventDispatcherImpl;
import com.spectralogic.ds3client.helpers.strategy.transferstrategy.GetJobNetworkFailureRetryDecorator;
import com.spectralogic.ds3client.helpers.strategy.transferstrategy.MaxNumObjectTransferAttemptsDecorator;
import com.spectralogic.ds3client.helpers.strategy.transferstrategy.MultiThreadedTransferStrategy;
import com.spectralogic.ds3client.helpers.strategy.transferstrategy.PutJobTransferMethod;
import com.spectralogic.ds3client.helpers.strategy.transferstrategy.SingleThreadedTransferStrategy;
import com.spectralogic.ds3client.helpers.strategy.transferstrategy.TransferMethod;
import com.spectralogic.ds3client.helpers.strategy.transferstrategy.TransferMethodMaker;
import com.spectralogic.ds3client.helpers.strategy.transferstrategy.TransferRetryDecorator;
import com.spectralogic.ds3client.helpers.strategy.transferstrategy.TransferStrategy;
import com.spectralogic.ds3client.helpers.strategy.transferstrategy.UpdateStrategy;
import com.spectralogic.ds3client.models.BulkObject;
import com.spectralogic.ds3client.models.ChecksumType;
import com.spectralogic.ds3client.models.MasterObjectList;
import com.spectralogic.ds3client.models.Objects;
import com.spectralogic.ds3client.models.common.Range;
import com.spectralogic.ds3client.utils.Guard;
import com.spectralogic.ds3client.utils.SeekableByteChannelInputStream;
import com.spectralogic.ds3client.utils.hashing.ChecksumUtils;
import com.spectralogic.ds3client.utils.hashing.Hasher;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.ByteChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TransferStrategyBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(TransferStrategyBuilder.class);
    private static final int DEFAULT_MAX_CONCURRENT_TRANSFER_THREADS = 10;
    public static final int DEFAULT_CHUNK_ATTEMPT_RETRY_INTERVAL = -1;
    public static final int DEFAULT_CHUNK_ATTEMPT_RETRY_ATTEMPTS = -1;
    public static final int DEFAULT_OBJECT_TRANSFER_ATTEMPTS = 5;
    private BlobStrategy blobStrategy;
    private ChannelStrategy channelStrategy;
    private String bucketName;
    private String jobId;
    private TransferRetryDecorator transferRetryDecorator = new MaxNumObjectTransferAttemptsDecorator(5);
    private ChecksumFunction checksumFunction;
    private ChecksumType.Type checksumType = ChecksumType.Type.NONE;
    private EventRunner eventRunner = new SameThreadEventRunner();
    private EventDispatcher eventDispatcher = new EventDispatcherImpl(this.eventRunner);
    private JobPartTracker jobPartTracker;
    private JobState jobState;
    private int numTransferRetries = 5;
    private int numConcurrentTransferThreads = 10;
    private int numChunkAttemptRetries = -1;
    private int chunkRetryDelayInSeconds = -1;
    private Ds3Client ds3Client;
    private MasterObjectList masterObjectList;
    private Ds3ClientHelpers.ObjectChannelBuilder channelBuilder;
    private ImmutableMap<String, ImmutableMultimap<BulkObject, Range>> rangesForBlobs;
    private MetadataAccess metadataAccess;
    private ChunkAttemptRetryBehavior chunkAttemptRetryBehavior;
    private ChunkAttemptRetryDelayBehavior chunkAttemptRetryDelayBehavior;
    private TransferBehaviorType transferBehaviorType = TransferBehaviorType.OriginalSdkTransferBehavior;
    private FailureEvent.FailureActivity failureActivity = FailureEvent.FailureActivity.PuttingObject;

    public TransferStrategyBuilder withBlobStrategy(BlobStrategy blobStrategy) {
        this.blobStrategy = blobStrategy;
        return this;
    }

    public TransferStrategyBuilder withChannelStrategy(ChannelStrategy channelStrategy) {
        this.channelStrategy = channelStrategy;
        return this;
    }

    public TransferStrategyBuilder withChannelBuilder(Ds3ClientHelpers.ObjectChannelBuilder channelBuilder) {
        this.channelBuilder = channelBuilder;
        return this;
    }

    public TransferStrategyBuilder withTransferRetryDecorator(TransferRetryDecorator transferRetryDecorator) {
        this.transferRetryDecorator = transferRetryDecorator;
        return this;
    }

    public TransferStrategyBuilder withChecksumFunction(ChecksumFunction checksumFunction) {
        this.checksumFunction = checksumFunction;
        return this;
    }

    public TransferStrategyBuilder withChecksumType(ChecksumType.Type checksumType) {
        this.checksumType = checksumType;
        return this;
    }

    public TransferStrategyBuilder withEventDispatcher(EventDispatcher eventDispatcher) {
        this.eventDispatcher = eventDispatcher;
        return this;
    }

    public EventDispatcher eventDispatcher() {
        return this.eventDispatcher;
    }

    public TransferStrategyBuilder withNumTransferRetries(int numRetries) {
        this.numTransferRetries = numRetries;
        return this;
    }

    public TransferStrategyBuilder withNumConcurrentTransferThreads(int numConcurrentTransferThreads) {
        this.numConcurrentTransferThreads = numConcurrentTransferThreads;
        return this;
    }

    public TransferStrategyBuilder withNumChunkAttemptRetries(int numChunkAttemptRetries) {
        this.numChunkAttemptRetries = numChunkAttemptRetries;
        return this;
    }

    public TransferStrategyBuilder withChunkRetryDelayInSeconds(int retryDelayInSeconds) {
        this.chunkRetryDelayInSeconds = retryDelayInSeconds;
        return this;
    }

    public TransferStrategyBuilder withDs3Client(Ds3Client ds3Client) {
        this.ds3Client = ds3Client;
        return this;
    }

    public TransferStrategyBuilder withMasterObjectList(MasterObjectList masterObjectList) {
        this.masterObjectList = masterObjectList;
        this.jobId = masterObjectList.getJobId().toString();
        this.bucketName = masterObjectList.getBucketName();
        return this;
    }

    public MasterObjectList masterObjectList() {
        return this.masterObjectList;
    }

    public TransferStrategyBuilder withRangesForBlobs(ImmutableMap<String, ImmutableMultimap<BulkObject, Range>> rangesForBlobs) {
        this.rangesForBlobs = rangesForBlobs;
        return this;
    }

    public TransferStrategyBuilder withMetadataAccess(MetadataAccess metadataAccess) {
        this.metadataAccess = metadataAccess;
        return this;
    }

    public TransferStrategyBuilder withChunkAttemptRetryBehavior(ChunkAttemptRetryBehavior chunkAttemptRetryBehavior) {
        this.chunkAttemptRetryBehavior = chunkAttemptRetryBehavior;
        return this;
    }

    public TransferStrategyBuilder withChunkAttemptRetryDelayBehavior(ChunkAttemptRetryDelayBehavior chunkAttemptRetryDelayBehavior) {
        this.chunkAttemptRetryDelayBehavior = chunkAttemptRetryDelayBehavior;
        return this;
    }

    public TransferStrategyBuilder withEventRunner(EventRunner eventRunner) {
        this.eventRunner = eventRunner;
        return this;
    }

    public TransferStrategyBuilder usingStreamedTransferBehavior() {
        this.transferBehaviorType = TransferBehaviorType.StreamingTransferBehavior;
        return this;
    }

    public TransferStrategyBuilder usingRandomAccessTransferBehavior() {
        this.transferBehaviorType = TransferBehaviorType.RandomAccessTransferBehavior;
        return this;
    }

    public TransferStrategy makePutTransferStrategy() {
        this.failureActivity = FailureEvent.FailureActivity.PuttingObject;
        switch (this.transferBehaviorType) {
            case StreamingTransferBehavior: {
                return this.makeStreamingPutTransferStrategy();
            }
            case RandomAccessTransferBehavior: {
                return this.makeRandomAccessPutTransferStrategy();
            }
        }
        return this.makeOriginalSdkSemanticsPutTransferStrategy();
    }

    private TransferStrategy makeStreamingPutTransferStrategy() {
        this.maybeMakeStreamedPutChannelStrategy();
        this.getOrMakeTransferRetryDecorator();
        return this.makeTransferStrategy((client, masterObjectList, eventDispatcher) -> new PutSequentialBlobStrategy(this.ds3Client, masterObjectList, eventDispatcher, this.getOrMakeChunkAttemptRetryBehavior(), this.getOrMakeChunkAllocationRetryDelayBehavior()), this::makePutTransferMethod);
    }

    private void maybeMakeStreamedPutChannelStrategy() {
        if (this.channelStrategy == null) {
            Preconditions.checkNotNull((Object)this.channelBuilder, (Object)"channelBuilder my not be null");
            this.channelStrategy = new SequentialChannelStrategy(new SequentialFileReaderChannelStrategy(this.channelBuilder), this.channelBuilder, new NullChannelPreparable(), this.masterObjectList);
        }
    }

    private TransferRetryDecorator getOrMakeTransferRetryDecorator() {
        if (this.transferRetryDecorator != null) {
            return this.transferRetryDecorator;
        }
        this.transferRetryDecorator = this.numTransferRetries > 0 ? new MaxNumObjectTransferAttemptsDecorator(this.numTransferRetries) : new ContinueForeverTransferRetryDecorator();
        return this.transferRetryDecorator;
    }

    private TransferStrategy makeTransferStrategy(BlobStrategyMaker blobStrategyMaker, TransferMethodMaker transferMethodMaker) {
        Preconditions.checkNotNull((Object)this.ds3Client, (Object)"ds3Client may not be null.");
        Preconditions.checkNotNull((Object)this.eventDispatcher, (Object)"eventDispatcher may not be null.");
        Preconditions.checkNotNull((Object)this.masterObjectList, (Object)"masterObjectList may not be null.");
        Preconditions.checkNotNull((Object)blobStrategyMaker, (Object)"blobStrategyMaker may not be null.");
        Preconditions.checkNotNull((Object)transferMethodMaker, (Object)"transferMethodMaker may not be null.");
        Preconditions.checkNotNull((Object)this.channelStrategy, (Object)"channelStrategy may not be null");
        Preconditions.checkNotNull((Object)this.transferRetryDecorator, (Object)"transferRetryDecorator may not be null");
        Guard.throwOnNullOrEmptyString((String)this.bucketName, (String)"bucketName may not be null or empty.");
        Guard.throwOnNullOrEmptyString((String)this.jobId, (String)"jobId may not be null or empty.");
        this.maybeMakeBlobStrategy(blobStrategyMaker);
        this.eventDispatcher.attachBlobTransferredEventObserver(new BlobTransferredEventObserver(new UpdateStrategy<BulkObject>(){

            @Override
            public void update(BulkObject eventData) {
                TransferStrategyBuilder.this.jobPartTracker.completePart(eventData.getName(), new ObjectPart(eventData.getOffset(), eventData.getLength()));
            }
        }));
        return this.makeTransferStrategy(transferMethodMaker.makeTransferMethod());
    }

    private void maybeMakeBlobStrategy(BlobStrategyMaker blobStrategyMaker) {
        if (this.blobStrategy == null) {
            this.blobStrategy = blobStrategyMaker.makeBlobStrategy(this.ds3Client, this.masterObjectList, this.eventDispatcher);
        }
    }

    private TransferStrategy makeTransferStrategy(TransferMethod transferMethod) {
        switch (this.transferBehaviorType) {
            case StreamingTransferBehavior: {
                return new SingleThreadedTransferStrategy(this.blobStrategy, this.jobState, this.eventDispatcher, this.masterObjectList, this.ds3Client, this.failureActivity).withTransferMethod(transferMethod);
            }
            case RandomAccessTransferBehavior: {
                return new MultiThreadedTransferStrategy(this.blobStrategy, this.jobState, this.numConcurrentTransferThreads, this.eventDispatcher, this.masterObjectList, this.ds3Client, this.failureActivity).withTransferMethod(transferMethod);
            }
        }
        return this.makeOriginalSdkSemanticsTransferStrategy(transferMethod);
    }

    private ChunkAttemptRetryBehavior getOrMakeChunkAttemptRetryBehavior() {
        if (this.chunkAttemptRetryBehavior != null) {
            return this.chunkAttemptRetryBehavior;
        }
        this.chunkAttemptRetryBehavior = this.numChunkAttemptRetries > 0 ? new MaxChunkAttemptsRetryBehavior(this.numChunkAttemptRetries) : new ContinueForeverChunkAttemptsRetryBehavior();
        return this.chunkAttemptRetryBehavior;
    }

    private ChunkAttemptRetryDelayBehavior getOrMakeChunkAllocationRetryDelayBehavior() {
        Preconditions.checkNotNull((Object)this.eventDispatcher, (Object)"eventDispatcher may not be null.");
        if (this.chunkAttemptRetryDelayBehavior != null) {
            return this.chunkAttemptRetryDelayBehavior;
        }
        this.chunkAttemptRetryDelayBehavior = this.chunkRetryDelayInSeconds > 0 ? new ClientDefinedChunkAttemptRetryDelayBehavior(this.chunkRetryDelayInSeconds, this.eventDispatcher) : new BlackPearlChunkAttemptRetryDelayBehavior(this.eventDispatcher);
        return this.chunkAttemptRetryDelayBehavior;
    }

    private TransferStrategy makeOriginalSdkSemanticsPutTransferStrategy() {
        this.maybeMakeRandomAccessPutChannelStrategy();
        this.getOrMakeTransferRetryDecorator();
        return this.makeTransferStrategy(new BlobStrategyMaker(){

            @Override
            public BlobStrategy makeBlobStrategy(Ds3Client client, MasterObjectList masterObjectList, EventDispatcher eventDispatcher) {
                return new PutSequentialBlobStrategy(TransferStrategyBuilder.this.ds3Client, masterObjectList, eventDispatcher, TransferStrategyBuilder.this.getOrMakeChunkAttemptRetryBehavior(), TransferStrategyBuilder.this.getOrMakeChunkAllocationRetryDelayBehavior());
            }
        }, new TransferMethodMaker(){

            @Override
            public TransferMethod makeTransferMethod() {
                return TransferStrategyBuilder.this.makePutTransferMethod();
            }
        });
    }

    private void maybeMakeRandomAccessPutChannelStrategy() {
        if (this.channelStrategy == null) {
            Preconditions.checkNotNull((Object)this.channelBuilder, (Object)"channelBuilder my not be null");
            this.channelStrategy = new RandomAccessChannelStrategy(this.channelBuilder, this.rangesForBlobs, new NullChannelPreparable());
        }
    }

    private TransferMethod makePutTransferMethod() {
        this.getOrMakeJobStateForPutJob();
        if (this.checksumType != ChecksumType.Type.NONE) {
            this.maybeAddChecksumFunction();
        }
        PutJobTransferMethod transferMethod = new PutJobTransferMethod(this.channelStrategy, this.bucketName, this.jobId, this.eventDispatcher, this.checksumFunction, this.checksumType, this.metadataAccess);
        if (this.transferRetryDecorator != null) {
            return this.transferRetryDecorator.wrap(transferMethod);
        }
        return transferMethod;
    }

    private JobState getOrMakeJobStateForPutJob() {
        if (this.jobState != null) {
            return this.jobState;
        }
        Preconditions.checkNotNull((Object)this.masterObjectList, (Object)"masterObjectList may not be null.");
        Preconditions.checkNotNull((Object)this.eventDispatcher, (Object)"eventDispatcher may not be null.");
        Preconditions.checkNotNull((Object)this.eventRunner, (Object)"eventRunner may not be null.");
        List<Objects> chunks = this.masterObjectList.getObjects();
        if (chunks == null) {
            chunks = new ArrayList<Objects>();
        }
        ImmutableList<Objects> chunksNotYetCompleted = StrategyUtils.filterChunks(chunks);
        this.getOrMakeJobPartTrackerForPutJob((List<Objects>)chunksNotYetCompleted);
        this.jobState = new JobState((Collection<Objects>)chunksNotYetCompleted);
        return this.jobState;
    }

    private void maybeAddChecksumFunction() {
        if (this.checksumFunction == null) {
            this.makeDefaultChecksumFunction();
        }
    }

    private TransferStrategy makeOriginalSdkSemanticsTransferStrategy(TransferMethod transferMethod) {
        if (this.numConcurrentTransferThreads > 1) {
            return new MultiThreadedTransferStrategy(this.blobStrategy, this.jobState, this.numConcurrentTransferThreads, this.eventDispatcher, this.masterObjectList, this.ds3Client, this.failureActivity).withTransferMethod(transferMethod);
        }
        return new SingleThreadedTransferStrategy(this.blobStrategy, this.jobState, this.eventDispatcher, this.masterObjectList, this.ds3Client, this.failureActivity).withTransferMethod(transferMethod);
    }

    private JobPartTracker getOrMakeJobPartTrackerForPutJob(List<Objects> chunksNotYetCompleted) {
        if (this.jobPartTracker != null) {
            return this.jobPartTracker;
        }
        JobPartTracker result = JobPartTrackerFactory.buildPartTracker(Iterables.concat((Iterable[])new Iterable[]{TransferStrategyBuilder.getBlobs(chunksNotYetCompleted)}), this.eventRunner);
        result.attachObjectCompletedListener(new ObjectCompletedListener(){

            @Override
            public void objectCompleted(String name) {
                TransferStrategyBuilder.this.eventDispatcher.emitObjectCompletedEvent(name);
            }
        });
        this.jobPartTracker = result;
        return this.jobPartTracker;
    }

    private static ImmutableList<BulkObject> getBlobs(List<Objects> chunks) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Objects objects : chunks) {
            builder.addAll(objects.getObjects());
        }
        return builder.build();
    }

    private void makeDefaultChecksumFunction() {
        this.checksumFunction = new ChecksumFunction(){

            @Override
            public String compute(BulkObject obj, ByteChannel channel) {
                String checksum = null;
                try {
                    SeekableByteChannelInputStream dataStream = new SeekableByteChannelInputStream(TransferStrategyBuilder.this.channelStrategy.acquireChannelForBlob(obj));
                    ((InputStream)dataStream).mark(Integer.MAX_VALUE);
                    Hasher hasher = ChecksumUtils.getHasher(TransferStrategyBuilder.this.checksumType);
                    checksum = ChecksumUtils.hashInputStream(hasher, dataStream);
                    LOG.info("Computed checksum for blob: {}", (Object)checksum);
                    ((InputStream)dataStream).reset();
                }
                catch (IOException e) {
                    TransferStrategyBuilder.this.eventDispatcher.emitFailureEvent(FailureEvent.builder().withObjectNamed(obj.getName()).withCausalException((Throwable)e).usingSystemWithEndpoint(TransferStrategyBuilder.this.ds3Client.getConnectionDetails().getEndpoint()).doingWhat(FailureEvent.FailureActivity.ComputingChecksum).build());
                    LOG.error("Error computing checksum.", (Throwable)e);
                }
                return checksum;
            }
        };
    }

    private TransferStrategy makeRandomAccessPutTransferStrategy() {
        this.maybeMakeRandomAccessPutChannelStrategy();
        this.getOrMakeTransferRetryDecorator();
        return this.makeTransferStrategy(new BlobStrategyMaker(){

            @Override
            public BlobStrategy makeBlobStrategy(Ds3Client client, MasterObjectList masterObjectList, EventDispatcher eventDispatcher) {
                return new PutSequentialBlobStrategy(TransferStrategyBuilder.this.ds3Client, masterObjectList, eventDispatcher, TransferStrategyBuilder.this.getOrMakeChunkAttemptRetryBehavior(), TransferStrategyBuilder.this.getOrMakeChunkAllocationRetryDelayBehavior());
            }
        }, new TransferMethodMaker(){

            @Override
            public TransferMethod makeTransferMethod() {
                return TransferStrategyBuilder.this.makePutTransferMethod();
            }
        });
    }

    public TransferStrategy makeGetTransferStrategy() {
        this.failureActivity = FailureEvent.FailureActivity.GettingObject;
        switch (this.transferBehaviorType) {
            case StreamingTransferBehavior: {
                return this.makeStreamingGetTransferStrategy();
            }
        }
        return this.makeOriginalSdkSemanticsGetTransferStrategy();
    }

    private TransferStrategy makeStreamingGetTransferStrategy() {
        this.maybeMakeSequentialGetChannelStrategy();
        this.getOrMakeTransferRetryDecorator();
        return this.makeTransferStrategy((client, masterObjectList, eventDispatcher) -> new GetSequentialBlobStrategy(this.ds3Client, masterObjectList, eventDispatcher, this.getOrMakeChunkAttemptRetryBehavior(), this.getOrMakeChunkAllocationRetryDelayBehavior()), this::makeGetTransferMethod);
    }

    private void maybeMakeSequentialGetChannelStrategy() {
        if (this.channelStrategy == null) {
            Preconditions.checkNotNull((Object)this.channelBuilder, (Object)"channelBuilder my not be null");
            this.channelStrategy = new SequentialChannelStrategy(new SequentialFileWriterChannelStrategy(this.channelBuilder), this.channelBuilder, new TruncatingChannelPreparable(), this.masterObjectList);
        }
    }

    private TransferMethod makeGetTransferMethod() {
        this.getOrMakeJobStateForGetJob();
        GetJobNetworkFailureRetryDecorator transferMethod = new GetJobNetworkFailureRetryDecorator(this.channelStrategy, this.bucketName, this.jobId, this.eventDispatcher, this.rangesForBlobs);
        if (this.transferRetryDecorator != null) {
            return this.transferRetryDecorator.wrap(transferMethod);
        }
        return transferMethod;
    }

    private JobState getOrMakeJobStateForGetJob() {
        if (this.jobState != null) {
            return this.jobState;
        }
        Preconditions.checkNotNull((Object)this.masterObjectList, (Object)"masterObjectList may not be null.");
        Preconditions.checkNotNull((Object)this.eventDispatcher, (Object)"eventDispatcher may not be null.");
        Preconditions.checkNotNull((Object)this.eventRunner, (Object)"eventRunner may not be null.");
        List<Objects> chunks = this.masterObjectList.getObjects();
        this.getOrMakeJobPartTrackerForGetJob(chunks);
        this.jobState = new JobState(chunks);
        return this.jobState;
    }

    private JobPartTracker getOrMakeJobPartTrackerForGetJob(List<Objects> chunks) {
        if (this.jobPartTracker != null) {
            return this.jobPartTracker;
        }
        JobPartTracker result = JobPartTrackerFactory.buildPartTracker(TransferStrategyBuilder.getBlobs(chunks), this.eventRunner);
        result.attachObjectCompletedListener(new ObjectCompletedListener(){

            @Override
            public void objectCompleted(String name) {
                TransferStrategyBuilder.this.eventDispatcher.emitObjectCompletedEvent(name);
            }
        });
        this.jobPartTracker = result;
        return this.jobPartTracker;
    }

    private TransferStrategy makeOriginalSdkSemanticsGetTransferStrategy() {
        this.maybeMakeRandomAccessGetChannelStrategy();
        this.getOrMakeTransferRetryDecorator();
        return this.makeTransferStrategy(new BlobStrategyMaker(){

            @Override
            public BlobStrategy makeBlobStrategy(Ds3Client client, MasterObjectList masterObjectList, EventDispatcher eventDispatcher) {
                return new GetSequentialBlobStrategy(TransferStrategyBuilder.this.ds3Client, masterObjectList, eventDispatcher, TransferStrategyBuilder.this.getOrMakeChunkAttemptRetryBehavior(), TransferStrategyBuilder.this.getOrMakeChunkAllocationRetryDelayBehavior());
            }
        }, new TransferMethodMaker(){

            @Override
            public TransferMethod makeTransferMethod() {
                return TransferStrategyBuilder.this.makeGetTransferMethod();
            }
        });
    }

    private void maybeMakeRandomAccessGetChannelStrategy() {
        if (this.channelStrategy == null) {
            Preconditions.checkNotNull((Object)this.channelBuilder, (Object)"channelBuilder my not be null");
            this.channelStrategy = new RandomAccessChannelStrategy(this.channelBuilder, this.rangesForBlobs, new TruncatingChannelPreparable());
        }
    }

    private static enum TransferBehaviorType {
        OriginalSdkTransferBehavior,
        StreamingTransferBehavior,
        RandomAccessTransferBehavior;

    }
}

