/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.models;

import java.nio.charset.StandardCharsets;
import org.apache.commons.codec.binary.Base64;

public abstract class ChecksumType {
    private static final ChecksumType none = new None();
    private static final ChecksumType compute = new Compute();

    public static ChecksumType none() {
        return none;
    }

    public static ChecksumType compute() {
        return compute;
    }

    public static ChecksumType value(String hash) {
        return new Value(hash);
    }

    public static ChecksumType value(byte[] hash) {
        String hashStr = Base64.encodeBase64String((byte[])hash);
        return new Value(hashStr);
    }

    public abstract <T, E extends Throwable> T match(MatchHandler<T, E> var1) throws E;

    private ChecksumType() {
    }

    private static class Value
    extends ChecksumType {
        private final String hash;

        public Value(String hash) {
            this.hash = hash;
        }

        @Override
        public <T, E extends Throwable> T match(MatchHandler<T, E> handler) throws E {
            return handler.value(this.hash.getBytes(StandardCharsets.UTF_8));
        }
    }

    private static class Compute
    extends ChecksumType {
        private Compute() {
        }

        @Override
        public <T, E extends Throwable> T match(MatchHandler<T, E> handler) throws E {
            return handler.compute();
        }
    }

    private static class None
    extends ChecksumType {
        private None() {
        }

        @Override
        public <T, E extends Throwable> T match(MatchHandler<T, E> handler) throws E {
            return handler.none();
        }
    }

    public static interface MatchHandler<T, E extends Throwable> {
        public T none() throws E;

        public T compute() throws E;

        public T value(byte[] var1) throws E;
    }

    public static enum Type {
        CRC_32,
        CRC_32C,
        MD5,
        SHA_256,
        SHA_512,
        NONE;

    }
}

