/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.models.common;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import java.util.Objects;

public final class Range
implements Comparable<Range> {
    @JacksonXmlProperty(localName="Offset", isAttribute=true)
    private final long start;
    @JsonIgnore
    private final long end;
    @JacksonXmlProperty(localName="Length", isAttribute=true)
    private final long length;

    public static Range byPosition(long start, long end) {
        return new Range(start, end);
    }

    public static Range byLength(long offset, long length) {
        return new Range(offset, offset + length - 1L);
    }

    public Range(long start, long end) {
        this.start = start;
        this.end = end;
        this.length = end - start + 1L;
    }

    public long getLength() {
        return this.length;
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    public int hashCode() {
        return Objects.hash(this.start, this.end, this.length);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Range) {
            Range range = (Range)obj;
            return range.start == this.start && range.end == this.end;
        }
        return false;
    }

    @Override
    public int compareTo(Range o) {
        return Long.compare(this.getStart(), o.getStart());
    }

    public String toString() {
        return "Range{start=" + this.start + ", end=" + this.end + ", length=" + this.length + '}';
    }
}

