/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.serializer;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import com.fasterxml.jackson.dataformat.xml.JacksonXmlModule;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.dataformat.xml.deser.FromXmlParser;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.spectralogic.ds3client.models.bulk.Ds3ObjectList;
import com.spectralogic.ds3client.serializer.Views;
import com.spectralogic.ds3client.serializer.XmlProcessingException;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class XmlOutput {
    private static final JacksonXmlModule module;
    private static final XmlMapper mapper;
    private static final Logger LOG;
    public static final String PRODUCTION_BUILD = "productionBuild";

    protected static boolean isProductionBuild() {
        String productionBuild = System.getenv(PRODUCTION_BUILD);
        return productionBuild == null || !productionBuild.equals("false");
    }

    public static String toXml(Object object) {
        return XmlOutput.toXml(object, null);
    }

    private static String toXml(Object object, Class view) {
        try {
            if (view == null) {
                return mapper.writeValueAsString(object);
            }
            return mapper.writerWithView(view).writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new XmlProcessingException((Exception)((Object)e));
        }
    }

    public static String toXml(Ds3ObjectList objects, boolean isBulkPut) {
        if (isBulkPut) {
            return XmlOutput.toXml((Object)objects, Views.PutObject.class);
        }
        return XmlOutput.toXml((Object)objects, Views.GetObject.class);
    }

    public static <T> T fromXml(String xmlString, Class<T> type) throws IOException {
        return (T)mapper.readValue(xmlString, type);
    }

    public static <T> T fromXml(InputStream stream, Class<T> type) throws IOException {
        return (T)mapper.readValue(stream, type);
    }

    static {
        LOG = LoggerFactory.getLogger(XmlOutput.class);
        module = new JacksonXmlModule();
        module.setDefaultUseWrapper(false);
        mapper = new XmlMapper(module);
        mapper.configure(FromXmlParser.Feature.EMPTY_ELEMENT_AS_NULL, true);
        mapper.registerModule((Module)new Jdk8Module());
        SimpleFilterProvider filterProvider = new SimpleFilterProvider().setFailOnUnknownId(false);
        mapper.setFilterProvider((FilterProvider)filterProvider);
        if (XmlOutput.isProductionBuild()) {
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        } else {
            LOG.info("Non-production build: Asserting on de-serializing unknown elements and attributes in XML response payloads.");
        }
    }
}

