/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.utils.collections;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class LazyIterable<T>
implements Iterable<T> {
    private final LazyLoaderFactory<T> lazyLoaderFactory;

    public LazyIterable(LazyLoaderFactory<T> lazyLoaderFactory) {
        this.lazyLoaderFactory = lazyLoaderFactory;
    }

    @Override
    public Iterator<T> iterator() {
        return new LazyObjectIterator(this.lazyLoaderFactory.create());
    }

    private static class LazyObjectIterator<E>
    implements Iterator<E> {
        private final LazyLoader<E> iterableLoader;
        private Iterator<E> cache = null;
        private boolean endOfContent = false;

        private LazyObjectIterator(LazyLoader<E> iterableLoader) {
            this.iterableLoader = iterableLoader;
        }

        @Override
        public boolean hasNext() {
            if (this.endOfContent) {
                return false;
            }
            if (this.cache == null || !this.cache.hasNext()) {
                this.loadCache();
            }
            return !this.endOfContent;
        }

        @Override
        public E next() {
            if (this.endOfContent) {
                throw new NoSuchElementException("No more content");
            }
            if (this.cache == null || !this.cache.hasNext()) {
                this.loadCache();
            }
            return this.cache.next();
        }

        private void loadCache() {
            this.cache = this.iterableLoader.getNextValues().iterator();
            if (!this.cache.hasNext()) {
                this.endOfContent = true;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("The remove method on the LazyObjectIterator is not supported");
        }
    }

    public static interface LazyLoader<T> {
        public Iterable<T> getNextValues();
    }

    public static interface LazyLoaderFactory<T> {
        public LazyLoader<T> create();
    }
}

