/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.utils.hashing;

import com.spectralogic.ds3client.utils.hashing.Hasher;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.zip.Checksum;
import org.apache.commons.codec.binary.Base64;

abstract class ChecksumHasher
implements Hasher {
    private final Checksum checksum = this.getChecksum();

    protected abstract Checksum getChecksum();

    @Override
    public void update(byte[] bytes, int offset, int length) {
        this.checksum.update(bytes, offset, length);
    }

    @Override
    public String digest() {
        return Base64.encodeBase64String((byte[])ChecksumHasher.toBytes(this.checksum.getValue()));
    }

    private static byte[] toBytes(long x) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.order(ByteOrder.BIG_ENDIAN);
        buffer.putLong(x);
        byte[] bytes = new byte[4];
        System.arraycopy(buffer.array(), 4, bytes, 0, 4);
        return bytes;
    }
}

