/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.codegen.constant;

import com.speedment.common.codegen.constant.SimpleParameterizedType;
import com.speedment.common.codegen.constant.SimpleType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.Stack;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.DoubleFunction;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.LongFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;

public final class DefaultType {
    public static final Type WILDCARD = SimpleType.create("?");
    private static final Map<String, Class<?>> WRAPPERS;

    private DefaultType() {
    }

    public static Type genericType(Type type, Type ... typeParameters) {
        return SimpleParameterizedType.create(type, typeParameters);
    }

    public static Type genericType(Type type, String ... typeParameters) {
        return SimpleParameterizedType.create(type, (Type[])Stream.of(typeParameters).map(SimpleType::create).toArray(Type[]::new));
    }

    public static Type classOf(Type innerType) {
        return SimpleParameterizedType.create(Class.class, new Type[]{innerType});
    }

    public static Type list(Type innerType) {
        return SimpleParameterizedType.create(List.class, new Type[]{innerType});
    }

    public static Type set(Type innerType) {
        return SimpleParameterizedType.create(Set.class, new Type[]{innerType});
    }

    public static Type map(Type innerTypeA, Type innerTypeB) {
        return SimpleParameterizedType.create(Map.class, new Type[]{innerTypeA, innerTypeB});
    }

    public static Type queue(Type innerType) {
        return SimpleParameterizedType.create(Queue.class, new Type[]{innerType});
    }

    public static Type stack(Type innerType) {
        return SimpleParameterizedType.create(Stack.class, new Type[]{innerType});
    }

    public static Type optional(Type innerType) {
        return SimpleParameterizedType.create(Optional.class, new Type[]{innerType});
    }

    public static Type entry(Type innerTypeA, Type innerTypeB) {
        return SimpleParameterizedType.create(Map.Entry.class, new Type[]{innerTypeA, innerTypeB});
    }

    public static Type function(Type innerTypeA, Type innerTypeB) {
        return SimpleParameterizedType.create(Function.class, new Type[]{innerTypeA, innerTypeB});
    }

    public static Type bifunction(Type innerTypeA, Type innerTypeB, Type innerTypeC) {
        return SimpleParameterizedType.create(BiFunction.class, new Type[]{innerTypeA, innerTypeB, innerTypeC});
    }

    public static Type intFunction(Type innerType) {
        return SimpleParameterizedType.create(IntFunction.class, new Type[]{innerType});
    }

    public static Type longFunction(Type innerType) {
        return SimpleParameterizedType.create(LongFunction.class, new Type[]{innerType});
    }

    public static Type doubleFunction(Type innerType) {
        return SimpleParameterizedType.create(DoubleFunction.class, new Type[]{innerType});
    }

    public static Type toIntFunction(Type innerType) {
        return SimpleParameterizedType.create(ToIntFunction.class, new Type[]{innerType});
    }

    public static Type toLongFunction(Type innerType) {
        return SimpleParameterizedType.create(ToLongFunction.class, new Type[]{innerType});
    }

    public static Type toDoubleFunction(Type innerType) {
        return SimpleParameterizedType.create(ToDoubleFunction.class, new Type[]{innerType});
    }

    public static Type unaryOperator(Type innerType) {
        return SimpleParameterizedType.create(UnaryOperator.class, new Type[]{innerType});
    }

    public static Type binaryOperator(Type innerType) {
        return SimpleParameterizedType.create(BinaryOperator.class, new Type[]{innerType});
    }

    public static Type predicate(Type innerType) {
        return SimpleParameterizedType.create(Predicate.class, new Type[]{innerType});
    }

    public static Type bipredicate(Type innerTypeA, Type innerTypeB) {
        return SimpleParameterizedType.create(BiPredicate.class, new Type[]{innerTypeA, innerTypeB});
    }

    public static Type consumer(Type innerType) {
        return SimpleParameterizedType.create(Consumer.class, new Type[]{innerType});
    }

    public static Type biconsumer(Type innerTypeA, Type innerTypeB) {
        return SimpleParameterizedType.create(BiConsumer.class, new Type[]{innerTypeA, innerTypeB});
    }

    public static Type supplier(Type innerType) {
        return SimpleParameterizedType.create(Supplier.class, new Type[]{innerType});
    }

    public static Type stream(Type innerType) {
        return SimpleParameterizedType.create(Stream.class, new Type[]{innerType});
    }

    public static boolean isPrimitive(Type type) {
        return WRAPPERS.containsKey(type.getTypeName());
    }

    public static boolean isWrapper(Type type) {
        return WRAPPERS.values().stream().map(Class::getTypeName).anyMatch(type.getTypeName()::equals);
    }

    public static Class<?> wrapperFor(Type primitiveType) {
        return Objects.requireNonNull(WRAPPERS.get(primitiveType.getTypeName()), "No wrapper found for type '" + primitiveType.getTypeName() + "'.");
    }

    public static Stream<Type> primitiveTypes() {
        return WRAPPERS.keySet().stream().map(SimpleType::create);
    }

    public static Stream<Type> wrapperTypes() {
        return WRAPPERS.values().stream().map(Type.class::cast);
    }

    static {
        HashMap<String, Class> temp = new HashMap<String, Class>();
        temp.put("byte", Byte.class);
        temp.put("short", Short.class);
        temp.put("int", Integer.class);
        temp.put("long", Long.class);
        temp.put("float", Float.class);
        temp.put("double", Double.class);
        temp.put("boolean", Boolean.class);
        temp.put("char", Character.class);
        WRAPPERS = Collections.unmodifiableMap(temp);
    }
}

