/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.injector;

import java.util.Objects;
import java.util.stream.Stream;

@FunctionalInterface
public interface InjectBundle {
    public Stream<Class<?>> injectables();

    public static InjectBundle empty() {
        return Stream::empty;
    }

    public static InjectBundle of(Class<?> ... classes) {
        Objects.requireNonNull(classes);
        return () -> Stream.of(classes);
    }

    default public InjectBundle withBundle(InjectBundle next) {
        Objects.requireNonNull(next);
        return () -> Stream.concat(this.injectables(), next.injectables());
    }

    default public InjectBundle withComponent(Class<?> nextClass) {
        Objects.requireNonNull(nextClass);
        return this.withBundle(InjectBundle.of(nextClass));
    }
}

