/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.injector;

import com.speedment.common.injector.InjectorBuilder;
import com.speedment.common.injector.internal.InjectorImpl;
import com.speedment.common.logger.Logger;
import java.util.Optional;
import java.util.stream.Stream;

public interface Injector {
    public <T> T getOrThrow(Class<T> var1);

    public <T> T getAfterOrThrow(Class<T> var1, T var2);

    public <T> Optional<T> get(Class<T> var1);

    public <T> Optional<T> getAfter(Class<T> var1, T var2);

    public <T> Stream<T> stream(Class<T> var1);

    public Stream<Class<?>> injectables();

    public <T> T inject(T var1);

    public void stop();

    public ClassLoader classLoader();

    public InjectorBuilder newBuilder();

    public static InjectorBuilder builder() {
        return InjectorImpl.builder();
    }

    public static InjectorBuilder builder(ClassLoader classLoader) {
        return InjectorImpl.builder(classLoader);
    }

    public static Logger logger() {
        return InjectorImpl.LOGGER_INSTANCE;
    }
}

