/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.injector;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.function.Predicate;

public interface InjectorProxy {
    public boolean isApplicable(Class<?> var1);

    public void set(Field var1, Object var2, Object var3) throws IllegalAccessException;

    public <T> T newInstance(Constructor<T> var1, Object ... var2) throws InstantiationException, IllegalAccessException, InvocationTargetException;

    public Object invoke(Method var1, Object var2, Object ... var3) throws IllegalAccessException, InvocationTargetException;

    public static Predicate<? super Class<?>> samePackageOrBelow(Class<?> classInRootPackage) {
        Objects.requireNonNull(classInRootPackage);
        return InjectorProxy.samePackageOrBelow(classInRootPackage.getPackage().getName(), false);
    }

    public static Predicate<? super Class<?>> samePackageOrBelow(Class<?> classInRootPackage, boolean excludeInternalPackages) {
        Objects.requireNonNull(classInRootPackage);
        return InjectorProxy.samePackageOrBelow(classInRootPackage.getPackage().getName(), excludeInternalPackages);
    }

    public static Predicate<? super Class<?>> samePackageOrBelow(String rootPackage, boolean excludeInternalPackages) {
        Objects.requireNonNull(rootPackage);
        return clazz -> {
            String className = clazz.getName();
            if (excludeInternalPackages && className.contains(".internal.")) {
                return false;
            }
            return className.startsWith(rootPackage);
        };
    }
}

