/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.injector.exception;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public final class CyclicReferenceException
extends RuntimeException {
    private static final long serialVersionUID = -5890725902790625145L;
    private final List<Class<?>> stack;

    public CyclicReferenceException(Collection<Class<?>> stack) {
        this.stack = new LinkedList(stack);
    }

    public CyclicReferenceException(Class<?> referencedClass) {
        this.stack = Collections.singletonList(referencedClass);
    }

    public CyclicReferenceException(Class<?> referencingClass, CyclicReferenceException cause) {
        LinkedList list = new LinkedList(cause.stack);
        list.addFirst(referencingClass);
        this.stack = list;
    }

    @Override
    public String getMessage() {
        return "Cyclic dependency prevented class from being injected. Stack: " + this.stack.stream().map(Class::getSimpleName).collect(Collectors.toList()) + ".";
    }
}

