/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.injector.internal;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;

final class Injectable<T> {
    private final Class<T> cls;
    private final Supplier<T> supplier;

    Injectable(Class<T> cls, Supplier<T> supplier) {
        this.cls = Objects.requireNonNull(cls);
        this.supplier = supplier;
    }

    public Class<T> get() {
        return this.cls;
    }

    boolean hasSupplier() {
        return this.supplier != null;
    }

    public Supplier<T> supplier() {
        return Optional.ofNullable(this.supplier).orElseThrow(() -> new UnsupportedOperationException(String.format("Injectable %s does not have a supplier.", this.cls.getName())));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        Injectable that = (Injectable)o;
        return this.cls.equals(that.cls) && Objects.equals(this.supplier, that.supplier);
    }

    public int hashCode() {
        return Objects.hash(this.cls, this.supplier);
    }
}

