/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.injector.internal;

import com.speedment.common.injector.InjectBundle;
import com.speedment.common.injector.Injector;
import com.speedment.common.injector.InjectorBuilder;
import com.speedment.common.injector.InjectorProxy;
import com.speedment.common.injector.MissingArgumentStrategy;
import com.speedment.common.injector.State;
import com.speedment.common.injector.annotation.Config;
import com.speedment.common.injector.annotation.ExecuteBefore;
import com.speedment.common.injector.annotation.Inject;
import com.speedment.common.injector.annotation.InjectKey;
import com.speedment.common.injector.annotation.InjectOrNull;
import com.speedment.common.injector.annotation.WithState;
import com.speedment.common.injector.dependency.DependencyGraph;
import com.speedment.common.injector.dependency.DependencyNode;
import com.speedment.common.injector.exception.ConstructorResolutionException;
import com.speedment.common.injector.exception.InjectorException;
import com.speedment.common.injector.exception.MisusedAnnotationException;
import com.speedment.common.injector.exception.NoDefaultConstructorException;
import com.speedment.common.injector.execution.Execution;
import com.speedment.common.injector.execution.ExecutionBuilder;
import com.speedment.common.injector.internal.Injectable;
import com.speedment.common.injector.internal.InjectorImpl;
import com.speedment.common.injector.internal.StandardInjectorProxy;
import com.speedment.common.injector.internal.execution.ReflectionExecutionImpl;
import com.speedment.common.injector.internal.util.InjectorUtil;
import com.speedment.common.injector.internal.util.PrintUtil;
import com.speedment.common.injector.internal.util.PropertiesUtil;
import com.speedment.common.injector.internal.util.ReflectionUtil;
import com.speedment.common.injector.internal.util.StringUtil;
import com.speedment.common.logger.Level;
import com.speedment.common.logger.Logger;
import com.speedment.common.logger.LoggerManager;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class InjectorBuilderImpl
implements InjectorBuilder {
    public static final Logger INTERNAL_LOGGER = LoggerManager.getLogger(InjectorBuilderImpl.class);
    private static final Object UNINSTANTIATED = new Object();
    private final ClassLoader classLoader;
    private final Map<String, List<Injectable<?>>> injectables;
    private final List<ExecutionBuilder<?>> executions;
    private final Map<String, String> overriddenParams;
    private final Deque<InjectorProxy> proxies;
    private final Map<Class<?>, InjectorProxy> proxyCache;
    private Path configFileLocation;

    InjectorBuilderImpl() {
        this(InjectorBuilderImpl.defaultClassLoader(), Collections.emptySet());
    }

    InjectorBuilderImpl(ClassLoader classLoader) {
        this(classLoader, Collections.emptySet());
    }

    InjectorBuilderImpl(Set<Class<?>> injectables) {
        this(InjectorBuilderImpl.defaultClassLoader(), injectables);
    }

    private InjectorBuilderImpl(ClassLoader classLoader, Set<Class<?>> injectables) {
        Objects.requireNonNull(injectables);
        this.classLoader = Objects.requireNonNull(classLoader);
        this.injectables = new LinkedHashMap();
        this.executions = new LinkedList();
        this.overriddenParams = new HashMap<String, String>();
        this.proxies = new LinkedList<InjectorProxy>();
        this.proxyCache = new HashMap();
        this.configFileLocation = Paths.get("settings.properties", new String[0]);
        this.withInjectorProxy(new StandardInjectorProxy());
        injectables.forEach(this::withComponent);
    }

    InjectorBuilderImpl(InjectorBuilder toCopy) {
        Objects.requireNonNull(toCopy);
        if (!(toCopy instanceof InjectorBuilderImpl)) {
            throw new UnsupportedOperationException("Unable to copy " + toCopy.getClass() + " because only " + InjectorBuilderImpl.class.getSimpleName() + " is supported.");
        }
        InjectorBuilderImpl other = (InjectorBuilderImpl)toCopy;
        this.classLoader = other.classLoader;
        this.injectables = new LinkedHashMap(other.injectables);
        this.executions = new LinkedList(other.executions);
        this.overriddenParams = new HashMap<String, String>(other.overriddenParams);
        this.proxies = new LinkedList<InjectorProxy>(other.proxies);
        this.proxyCache = new HashMap();
        this.configFileLocation = other.configFileLocation;
    }

    @Override
    public InjectorBuilder withComponent(Class<?> injectableType) {
        Objects.requireNonNull(injectableType);
        return this.withComponentAndSupplier(injectableType, null);
    }

    @Override
    public <T> InjectorBuilder withComponent(Class<T> injectableType, Supplier<T> instanceSupplier) {
        Objects.requireNonNull(injectableType);
        Objects.requireNonNull(instanceSupplier);
        return this.withComponentAndSupplier(injectableType, instanceSupplier);
    }

    private <T> InjectorBuilder withComponentAndSupplier(Class<T> injectableType, Supplier<T> instanceSupplier) {
        Objects.requireNonNull(injectableType);
        if (InjectorProxy.class.isAssignableFrom(injectableType)) {
            InjectorProxy injectorProxy = instanceSupplier != null ? (InjectorProxy)instanceSupplier.get() : (InjectorProxy)this.newInstance(injectableType);
            this.withInjectorProxy(injectorProxy);
        }
        Injectable injectable = new Injectable(injectableType, instanceSupplier);
        this.appendInjectable(injectableType.getName(), injectable, true);
        ReflectionUtil.traverseAncestors(injectableType).filter(c -> c.isAnnotationPresent(InjectKey.class)).map(c -> c.getAnnotation(InjectKey.class)).forEachOrdered(key -> this.appendInjectable(key.value().getName(), injectable, key.overwrite()));
        return this;
    }

    @Override
    public InjectorBuilder withBundle(Class<? extends InjectBundle> bundleClass) {
        InjectBundle bundle = this.newInstance(bundleClass);
        bundle.injectables().forEachOrdered(this::withComponent);
        return this;
    }

    @Override
    public InjectorBuilder withInjectorProxy(InjectorProxy injectorProxy) {
        Objects.requireNonNull(injectorProxy);
        this.proxies.addFirst(injectorProxy);
        return this;
    }

    @Override
    public InjectorBuilder withConfigFileLocation(Path configFile) {
        this.configFileLocation = Objects.requireNonNull(configFile);
        return this;
    }

    @Override
    public InjectorBuilder withParam(String name, String value) {
        this.overriddenParams.put(name, value);
        return this;
    }

    @Override
    public <T> InjectorBuilder before(ExecutionBuilder<T> executionBuilder) {
        this.executions.add(Objects.requireNonNull(executionBuilder));
        return this;
    }

    @Override
    public Injector build() throws InstantiationException {
        File configFile = this.configFileLocation.toFile();
        Properties properties = PropertiesUtil.loadProperties(INTERNAL_LOGGER, configFile);
        this.overriddenParams.forEach(properties::setProperty);
        Set<Class<?>> allInjectableTypes = Collections.unmodifiableSet(this.injectables.values().stream().flatMap(Collection::stream).map(Injectable::get).collect(Collectors.toSet()));
        Set<Injectable<?>> injectablesSet = Collections.unmodifiableSet(this.injectables.values().stream().flatMap(Collection::stream).collect(Collectors.toCollection(LinkedHashSet::new)));
        DependencyGraph graph = DependencyGraph.create(injectablesSet.stream().map(Injectable::get), this::proxyFor);
        Map instanceMap = injectablesSet.stream().map(Injectable::get).collect(Collectors.toMap(Function.identity(), i -> UNINSTANTIATED, (a, b) -> a, LinkedHashMap::new));
        INTERNAL_LOGGER.debug(String.format("Creating %d injectable instances.", injectablesSet.size()));
        INTERNAL_LOGGER.debug("+---------------------------------------------------------------------------------+");
        LinkedHashSet injectablesLeft = new LinkedHashSet(injectablesSet);
        while (!injectablesLeft.isEmpty()) {
            this.tryToCreateInstances(properties, allInjectableTypes, instanceMap, injectablesLeft);
        }
        final LinkedList<Object> instances = this.instancesSoFarInReversedOrder(instanceMap);
        instanceMap.clear();
        final InjectorImpl injector = new InjectorImpl(injectablesSet, Collections.unmodifiableList(instances), properties, this.classLoader, graph, this);
        Execution.ClassMapper classMapper = new Execution.ClassMapper(){

            @Override
            public <T> T apply(Class<T> type) {
                return InjectorUtil.findIn(type, injector, instances, true);
            }

            @Override
            public <T> T applyOrNull(Class<T> type) {
                return InjectorUtil.findIn(type, injector, instances, false);
            }
        };
        instances.forEach(this::assertAnnotationsCorrect);
        instances.forEach(instance -> this.setAutoInjectedFields(instance, instances, injector));
        this.executions.stream().map(builder -> builder.build(graph)).forEachOrdered(execution -> {
            DependencyNode node = graph.get(execution.getType());
            node.getExecutions().add((Execution<?>)execution);
        });
        AtomicBoolean hasAnythingChanged = new AtomicBoolean();
        AtomicInteger nextState = new AtomicInteger(0);
        while (nextState.get() <= State.STARTED.ordinal()) {
            this.handleNextState(graph, instances, injector, classMapper, hasAnythingChanged, nextState);
        }
        INTERNAL_LOGGER.debug("+---------------------------------------------------------------------------------+");
        INTERNAL_LOGGER.debug("| %-79s |", (Object)("All " + instances.size() + " components have been configured!"));
        INTERNAL_LOGGER.debug("+---------------------------------------------------------------------------------+");
        return injector;
    }

    private void handleNextState(DependencyGraph graph, LinkedList<Object> instances, Injector injector, Execution.ClassMapper classMapper, AtomicBoolean hasAnythingChanged, AtomicInteger nextState) {
        Set<DependencyNode> unfinished;
        while (!(unfinished = graph.nodes().filter(n -> n.getCurrentState().ordinal() < nextState.get()).collect(Collectors.toSet())).isEmpty()) {
            hasAnythingChanged.set(false);
            unfinished.forEach(n -> {
                State state = n.getCurrentState().next();
                if (n.canBe(state)) {
                    INTERNAL_LOGGER.debug("+---------------------------------------------------------------------------------+");
                    Object instance = InjectorUtil.findIn(n.getRepresentedType(), injector, instances, false);
                    n.getExecutions().stream().filter(e -> e.getState() == state).map(exec -> {
                        Execution casted = exec;
                        return casted;
                    }).forEach(exec -> this.executionHandler(graph, classMapper, instance, (Execution<Object>)exec));
                    n.setState(state);
                    hasAnythingChanged.set(true);
                    INTERNAL_LOGGER.debug("| %-66s %12s |", (Object)PrintUtil.limit(n.getRepresentedType().getSimpleName(), 66), (Object)PrintUtil.limit(state.name(), 12));
                }
            });
            if (hasAnythingChanged.get()) continue;
            throw new IllegalStateException("The injector appears to be stuck in an infinite loop.");
        }
        nextState.incrementAndGet();
    }

    private void executionHandler(DependencyGraph graph, Execution.ClassMapper classMapper, Object instance, Execution<Object> exec) {
        if (INTERNAL_LOGGER.getLevel().isEqualOrLowerThan(Level.DEBUG)) {
            INTERNAL_LOGGER.debug("| -> %-76s |", (Object)PrintUtil.limit(exec.toString(), 76));
        }
        try {
            if (!exec.invoke(instance, classMapper)) {
                MissingArgumentStrategy i = exec.getMissingArgumentStrategy();
                if (i == MissingArgumentStrategy.THROW_EXCEPTION) {
                    throw new InjectorException(String.format("The injector could not invoke the method '%s' before state '%s' since one of the parameters is not available.", new Object[]{exec.getName(), exec.getState()}));
                }
                if (i == MissingArgumentStrategy.SKIP_INVOCATION && INTERNAL_LOGGER.getLevel().isEqualOrLowerThan(Level.DEBUG)) {
                    INTERNAL_LOGGER.debug("|      %-74s |", (Object)PrintUtil.limit("(Not invoked due to missing optional dependencies.)", 74));
                }
            }
        }
        catch (ReflectiveOperationException ex) {
            InjectorBuilderImpl.throwInjectorException(graph, exec, ex);
        }
    }

    static void throwInjectorException(DependencyGraph graph, Execution<Object> exec, Exception ex) {
        INTERNAL_LOGGER.error("Exception thrown by method invoked by Injector:");
        if (ex.getCause() != null) {
            INTERNAL_LOGGER.error("Exception: " + ex.getCause().getClass().getSimpleName());
        }
        INTERNAL_LOGGER.error("Class: " + exec.getType().getName());
        INTERNAL_LOGGER.error("    @ExecuteBefore(" + exec.getState().name() + ")");
        if (exec instanceof ReflectionExecutionImpl) {
            Method method = ((ReflectionExecutionImpl)exec).getMethod();
            INTERNAL_LOGGER.error(String.format("   %s %s %s%s", Modifier.toString(method.getModifiers()), method.getReturnType().getSimpleName(), method.getName(), method.getParameterCount() == 0 ? "()" : "("));
            if (method.getParameterCount() > 0) {
                Stream.of(method.getParameters()).map(param -> InjectorBuilderImpl.formatParameter(graph, param)).forEachOrdered(arg_0 -> ((Logger)INTERNAL_LOGGER).error(arg_0));
                INTERNAL_LOGGER.error("    );");
            }
        }
        throw new InjectorException(ex);
    }

    private static String formatParameter(DependencyGraph graph, Parameter param) {
        Config config = param.getAnnotation(Config.class);
        WithState withState = param.getAnnotation(WithState.class);
        if (config != null) {
            return String.format("        @Config(name=\"%s\", value=\"%s\") %s", config.name(), config.value(), param.getType().getSimpleName());
        }
        return String.format("        %s%s (%s)", withState == null ? "" : String.format("@WithState(%s) ", withState.value().name()), param.getType().getSimpleName(), graph.getIfPresent(param.getType()).map(node -> String.format("Implemented as: %s, state: %s", node.getRepresentedType().getSimpleName(), node.getCurrentState().name())).orElse("No implementation found"));
    }

    private void setAutoInjectedFields(Object instance, LinkedList<Object> instances, Injector injector) {
        ReflectionUtil.traverseFields(instance.getClass()).filter(f -> f.isAnnotationPresent(Inject.class) || f.isAnnotationPresent(InjectOrNull.class)).distinct().forEachOrdered(field -> {
            Injector value;
            if (Injector.class.isAssignableFrom(field.getType())) {
                value = injector;
            } else {
                try {
                    value = InjectorUtil.findIn(field.getType(), injector, instances, field.isAnnotationPresent(Inject.class));
                }
                catch (IllegalArgumentException ex) {
                    throw new IllegalArgumentException(String.format("The injectable class %s has a member field '%s' of type %s that could not be resolved in the Injector. You might be missing a required InjectBundle or Component. If the field should not be injected when it doesn't exist, try solving the problem by removing the @Inject-annotation from the field and pass it through an @Inject-annotated constructor instead, or change the annotation on the field to @InjectOrNull.", instance.getClass().getSimpleName(), field.getName(), field.getType().getSimpleName()), ex);
                }
            }
            try {
                INTERNAL_LOGGER.warn("Setting fields is deprecated: " + field);
                this.set((Field)field, instance, value);
            }
            catch (IllegalAccessException ex) {
                throw new InjectorException("Could not access field '" + field.getName() + "' in class '" + field.getDeclaringClass().getName() + "' of type '" + field.getType() + "'.", ex);
            }
        });
    }

    private void assertAnnotationsCorrect(Object instance) {
        ReflectionUtil.traverseMethods(instance.getClass()).filter(m -> m.isAnnotationPresent(ExecuteBefore.class)).forEach(m -> {
            ExecuteBefore execute = m.getAnnotation(ExecuteBefore.class);
            List errenousParams = Stream.of(m.getParameters()).filter(p -> p.isAnnotationPresent(WithState.class)).filter(p -> {
                State paramState = p.getAnnotation(WithState.class).value();
                return paramState != execute.value() && (!paramState.isBefore(State.STARTED) || paramState.next() != execute.value());
            }).collect(Collectors.toList());
            if (!errenousParams.isEmpty()) {
                throw new MisusedAnnotationException(String.format("The class %s has an auto-executed method %s(%s) that should execute just before the instance enters the %s state, so the parameters must %s when the method is invoked. Yet, the @WithState-annotation is present on %d parameter%s with requested state%s %s.", instance.getClass().getSimpleName(), m.getName(), Stream.of(m.getParameters()).map(Parameter::getType).map(Class::getSimpleName).collect(Collectors.joining(", ")), execute.value().name(), execute.value() == State.CREATED ? "also be in the CREATED state" : String.format("either be in the %s or the %s state", execute.value().previous().name(), execute.value().name()), errenousParams.size(), errenousParams.size() > 1 ? "s" : "", errenousParams.size() > 1 ? "s" : "", StringUtil.commaAnd((String[])errenousParams.stream().map(p -> p.getAnnotation(WithState.class)).map(WithState::value).map(Enum::name).toArray(String[]::new))));
            }
        });
    }

    private void tryToCreateInstances(Properties properties, Set<Class<?>> allInjectableTypes, Map<Class<?>, Object> instanceMap, Set<Injectable<?>> injectablesLeft) throws InstantiationException {
        int injectablesLeftSize = injectablesLeft.size();
        Iterator<Injectable<?>> it = injectablesLeft.iterator();
        while (it.hasNext()) {
            Injectable<?> injectable = it.next();
            boolean created = false;
            if (injectable.hasSupplier()) {
                Object instance = injectable.supplier().get();
                instanceMap.put(injectable.get(), instance);
                created = true;
            } else {
                Class<?> clazz = injectable.get();
                Optional<?> instance = ReflectionUtil.tryToCreate(clazz, properties, this.instancesSoFarInReversedOrder(instanceMap), allInjectableTypes, this.proxyFor(clazz));
                if (instance.isPresent()) {
                    instanceMap.put(injectable.get(), instance.get());
                    created = true;
                }
            }
            if (created) {
                this.logCreated(properties, injectable);
                it.remove();
                continue;
            }
            this.logPending(injectable);
        }
        if (injectablesLeftSize == injectablesLeft.size()) {
            this.throwNewConstructorResolutionException(injectablesLeft, instanceMap);
        }
    }

    private void logPending(Injectable<?> injectable) {
        if (INTERNAL_LOGGER.getLevel().isEqualOrLowerThan(Level.DEBUG)) {
            INTERNAL_LOGGER.debug("| %-71s PENDING |", (Object)PrintUtil.limit(injectable.get().getSimpleName(), 71));
            INTERNAL_LOGGER.debug("+---------------------------------------------------------------------------------+");
        }
    }

    private void logCreated(Properties properties, Injectable<?> injectable) {
        if (INTERNAL_LOGGER.getLevel().isEqualOrLowerThan(Level.DEBUG)) {
            INTERNAL_LOGGER.debug("| %-71s CREATED |", (Object)PrintUtil.limit(injectable.get().getSimpleName(), 71));
            ReflectionUtil.traverseFields(injectable.get()).filter(f -> f.isAnnotationPresent(Config.class)).map(f -> f.getAnnotation(Config.class)).map(a -> String.format("|     %-48s %26s |", PrintUtil.limit(a.name(), 48), PrintUtil.limit(properties.containsKey(a.name()) ? properties.get(a.name()).toString() : a.value(), 26))).forEachOrdered(arg_0 -> ((Logger)INTERNAL_LOGGER).debug(arg_0));
            INTERNAL_LOGGER.debug("+---------------------------------------------------------------------------------+");
        }
    }

    private void throwNewConstructorResolutionException(Set<Injectable<?>> injectablesLeft, Map<Class<?>, Object> instanceMap) {
        StringBuilder msg = new StringBuilder();
        msg.append(injectablesLeft.size());
        msg.append(" injectables could not be instantiated. These where: [\n");
        LinkedList<Object> instancesSoFarInCorrectOrder = this.instancesSoFarInReversedOrder(instanceMap);
        injectablesLeft.stream().map(Injectable::get).map(c -> ReflectionUtil.errorMsg(c, instancesSoFarInCorrectOrder)).forEachOrdered(s -> msg.append("  ").append((String)s).append('\n'));
        msg.append("]\n").append("Available candidates were: ").append(this.injectables.entrySet().stream().map(e -> String.format("%s:%d", e.getKey(), ((List)e.getValue()).size())).collect(Collectors.joining(", ", "[", "]")));
        throw new ConstructorResolutionException(msg.toString());
    }

    @Override
    public InjectorProxy proxyFor(Class<?> clazz) {
        return this.proxyCache.computeIfAbsent(clazz, this::computeProxyFor);
    }

    private LinkedList<Object> instancesSoFarInReversedOrder(Map<Class<?>, Object> instanceMap) {
        return instanceMap.values().stream().filter(o -> o != UNINSTANTIATED).collect(LinkedList::new, LinkedList::addFirst, LinkedList::addFirst);
    }

    private void appendInjectable(String key, Injectable<?> clazz, boolean overwrite) {
        List list = Optional.ofNullable(this.injectables.remove(key)).orElseGet(LinkedList::new);
        if (overwrite) {
            list.clear();
        }
        list.add(clazz);
        this.injectables.put(key, list);
    }

    private void set(Field field, Object instance, Object value) throws IllegalAccessException {
        InjectorProxy injectorProxy = this.proxyFor(instance.getClass());
        injectorProxy.set(field, instance, value);
    }

    private InjectorProxy computeProxyFor(Class<?> clazz) {
        return this.proxies.stream().filter(p -> p.isApplicable(clazz)).findFirst().orElseThrow(() -> new NoSuchElementException("Unable to find an InjectorProxy for " + clazz.getName() + ". Available proxies: " + this.proxies.stream().map(Object::toString).collect(Collectors.toList())));
    }

    private static ClassLoader defaultClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    private <T> T newInstance(Class<T> clazz) {
        try {
            return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new InjectorException(e);
        }
        catch (NoSuchMethodException e) {
            throw new NoDefaultConstructorException(e);
        }
    }
}

