/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.injector.internal;

import com.speedment.common.injector.Injector;
import com.speedment.common.injector.InjectorBuilder;
import com.speedment.common.injector.InjectorProxy;
import com.speedment.common.injector.State;
import com.speedment.common.injector.annotation.Inject;
import com.speedment.common.injector.annotation.InjectOrNull;
import com.speedment.common.injector.dependency.DependencyGraph;
import com.speedment.common.injector.dependency.DependencyNode;
import com.speedment.common.injector.exception.InjectorException;
import com.speedment.common.injector.execution.Execution;
import com.speedment.common.injector.internal.Injectable;
import com.speedment.common.injector.internal.InjectorBuilderImpl;
import com.speedment.common.injector.internal.util.InjectorUtil;
import com.speedment.common.injector.internal.util.PrintUtil;
import com.speedment.common.injector.internal.util.PropertiesUtil;
import com.speedment.common.injector.internal.util.ReflectionUtil;
import com.speedment.common.logger.Level;
import com.speedment.common.logger.Logger;
import com.speedment.common.logger.LoggerManager;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class InjectorImpl
implements Injector {
    public static final Logger LOGGER_INSTANCE = LoggerManager.getLogger(InjectorImpl.class);
    private final Set<Injectable<?>> injectables;
    private final List<Object> instances;
    private final Properties properties;
    private final ClassLoader classLoader;
    private final DependencyGraph graph;
    private final InjectorBuilder builder;

    public static InjectorBuilder builder() {
        return new InjectorBuilderImpl();
    }

    public static InjectorBuilder builder(ClassLoader classLoader) {
        return new InjectorBuilderImpl(classLoader);
    }

    InjectorImpl(Set<Injectable<?>> injectables, List<Object> instances, Properties properties, ClassLoader classLoader, DependencyGraph graph, InjectorBuilder builder) {
        this.injectables = Objects.requireNonNull(injectables);
        this.instances = Objects.requireNonNull(instances);
        this.properties = Objects.requireNonNull(properties);
        this.classLoader = Objects.requireNonNull(classLoader);
        this.graph = Objects.requireNonNull(graph);
        this.builder = Objects.requireNonNull(builder);
    }

    @Override
    public <T> Stream<T> stream(Class<T> type) {
        return this.findAll(type);
    }

    @Override
    public <T> T getOrThrow(Class<T> type) {
        return this.find(type, true);
    }

    @Override
    public <T> T getAfterOrThrow(Class<T> type, T before) {
        return this.getAfter(type, before).orElseThrow(() -> new IllegalArgumentException("A component after " + before + " of type " + type.getName() + " could not be found. Components of type " + type.getSimpleName() + ": " + this.stream(type).map(Object::getClass).map(Class::getSimpleName).collect(Collectors.joining(", "))));
    }

    @Override
    public <T> Optional<T> get(Class<T> type) {
        return Optional.ofNullable(this.find(type, false));
    }

    @Override
    public <T> Optional<T> getAfter(Class<T> type, T before) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(before);
        boolean found = false;
        Iterator i = this.stream(type).iterator();
        while (i.hasNext()) {
            Object t = i.next();
            if (found) {
                return Optional.of(t);
            }
            if (t != before) continue;
            found = true;
        }
        return Optional.empty();
    }

    @Override
    public Stream<Class<?>> injectables() {
        return this.injectables.stream().map(Injectable::get);
    }

    @Override
    public <T> T inject(T instance) {
        Objects.requireNonNull(instance);
        this.injectFields(instance);
        InjectorProxy injectorProxy = this.builder.proxyFor(instance.getClass());
        PropertiesUtil.configureParams(instance, this.properties, injectorProxy);
        return instance;
    }

    @Override
    public ClassLoader classLoader() {
        return this.classLoader;
    }

    @Override
    public void stop() {
        Set<DependencyNode> unfinished;
        AtomicBoolean hasAnythingChanged = new AtomicBoolean();
        Execution.ClassMapper classMapper = this::findRequired;
        while (!(unfinished = this.graph.nodes().filter(n -> n.getCurrentState() != State.STOPPED).collect(Collectors.toSet())).isEmpty()) {
            hasAnythingChanged.set(false);
            unfinished.forEach(n -> this.stop(hasAnythingChanged, classMapper, (DependencyNode)n));
            if (hasAnythingChanged.get()) continue;
            throw new IllegalStateException("Injector appears to be stuck in an infinite loop. The following components have not been stopped: " + unfinished.stream().map(DependencyNode::getRepresentedType).map(Class::getSimpleName).collect(Collectors.toSet()));
        }
        LOGGER_INSTANCE.debug("+---------------------------------------------------------------------------------+");
        LOGGER_INSTANCE.debug("| %-79s |", (Object)("All " + this.instances.size() + " components have been stopped!"));
        LOGGER_INSTANCE.debug("+---------------------------------------------------------------------------------+");
    }

    private void stop(AtomicBoolean hasAnythingChanged, Execution.ClassMapper classMapper, DependencyNode node) {
        if (node.canBe(State.STOPPED)) {
            LOGGER_INSTANCE.debug("+---------------------------------------------------------------------------------+");
            Object inst = this.find(node.getRepresentedType(), true);
            node.getExecutions().stream().filter(e -> e.getState() == State.STOPPED).map(exec -> {
                Execution casted = exec;
                return casted;
            }).forEach(exec -> this.stopInstance(classMapper, inst, (Execution<Object>)exec));
            node.setState(State.STOPPED);
            hasAnythingChanged.set(true);
            LOGGER_INSTANCE.debug("| %-66s %12s |", (Object)node.getRepresentedType().getSimpleName(), (Object)State.STOPPED.name());
        }
    }

    private void stopInstance(Execution.ClassMapper classMapper, Object inst, Execution<Object> exec) {
        if (LOGGER_INSTANCE.getLevel().isEqualOrLowerThan(Level.DEBUG)) {
            LOGGER_INSTANCE.debug("| -> %-76s |", (Object)PrintUtil.limit(exec.toString(), 76));
        }
        try {
            if (!exec.invoke(inst, classMapper) && LOGGER_INSTANCE.getLevel().isEqualOrLowerThan(Level.DEBUG)) {
                LOGGER_INSTANCE.debug("|      %-74s |", (Object)PrintUtil.limit("(Ignored due to missing dependencies.)", 74));
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            throw new InjectorException(ex);
        }
    }

    @Override
    public InjectorBuilder newBuilder() {
        return new InjectorBuilderImpl(this.builder);
    }

    private <T> Stream<T> findAll(Class<T> type) {
        return InjectorUtil.findAll(type, this, this.instances);
    }

    private <T> T findRequired(Class<T> type) {
        return this.find(type, true);
    }

    private <T> T find(Class<T> type, boolean required) {
        return InjectorUtil.findIn(type, this, this.instances, required);
    }

    private <T> void injectFields(T instance) {
        Objects.requireNonNull(instance);
        ReflectionUtil.traverseFields(instance.getClass()).filter(f -> f.isAnnotationPresent(Inject.class) || f.isAnnotationPresent(InjectOrNull.class)).distinct().forEachOrdered(field -> {
            InjectorImpl value = Injector.class.isAssignableFrom(field.getType()) ? this : this.find(field.getType(), field.isAnnotationPresent(Inject.class));
            try {
                InjectorProxy injectorProxy = this.builder.proxyFor(instance.getClass());
                injectorProxy.set((Field)field, instance, value);
            }
            catch (IllegalAccessException ex) {
                String err = String.format("Could not access field '%s' in class '%s' of type '%s'.", field.getName(), field.getDeclaringClass().getName(), field.getType());
                LOGGER_INSTANCE.error((Throwable)ex, err);
                throw new InjectorException(err, ex);
            }
        });
    }
}

