/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.injector.internal.dependency;

import com.speedment.common.injector.InjectorProxy;
import com.speedment.common.injector.State;
import com.speedment.common.injector.annotation.Execute;
import com.speedment.common.injector.annotation.ExecuteBefore;
import com.speedment.common.injector.annotation.WithState;
import com.speedment.common.injector.dependency.Dependency;
import com.speedment.common.injector.dependency.DependencyGraph;
import com.speedment.common.injector.dependency.DependencyNode;
import com.speedment.common.injector.exception.CyclicReferenceException;
import com.speedment.common.injector.execution.Execution;
import com.speedment.common.injector.internal.InjectorImpl;
import com.speedment.common.injector.internal.dependency.DependencyImpl;
import com.speedment.common.injector.internal.dependency.DependencyNodeImpl;
import com.speedment.common.injector.internal.dependency.InjectorDependencyNode;
import com.speedment.common.injector.internal.execution.ReflectionExecutionImpl;
import com.speedment.common.injector.internal.util.ReflectionUtil;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class DependencyGraphImpl
implements DependencyGraph {
    private final Map<Class<?>, DependencyNode> nodes;
    private final Function<Class<?>, InjectorProxy> proxyFunction;

    public DependencyGraphImpl(Function<Class<?>, InjectorProxy> proxyFunction) {
        this.proxyFunction = Objects.requireNonNull(proxyFunction);
        this.nodes = new ConcurrentHashMap();
        this.nodes.put(InjectorImpl.class, new InjectorDependencyNode());
    }

    @Override
    public DependencyNode get(Class<?> clazz) {
        return this.getIfPresent(clazz).orElseThrow(() -> new IllegalArgumentException(String.format("There is no implementation of '%s' in the injection dependency graph.", clazz)));
    }

    @Override
    public DependencyNode getOrCreate(Class<?> clazz) {
        return this.getIfPresent(clazz).orElseGet(() -> this.nodes.computeIfAbsent(clazz, DependencyNodeImpl::new));
    }

    @Override
    public Optional<DependencyNode> getIfPresent(Class<?> clazz) {
        for (Map.Entry<Class<?>, DependencyNode> impl : this.nodes.entrySet()) {
            if (!clazz.isAssignableFrom(impl.getKey())) continue;
            return Optional.of(impl.getValue());
        }
        return Optional.empty();
    }

    @Override
    public DependencyGraph inject() {
        this.nodes.forEach((clazz, node) -> {
            ReflectionUtil.traverseMethods(clazz).filter(m -> m.isAnnotationPresent(Execute.class)).forEach(m -> node.getExecutions().add(this.createExecution((Method)m, State.STARTED)));
            ReflectionUtil.traverseMethods(clazz).filter(m -> m.isAnnotationPresent(ExecuteBefore.class)).forEach(m -> {
                ExecuteBefore execute = m.getAnnotation(ExecuteBefore.class);
                node.getExecutions().add(this.createExecution((Method)m, execute.value()));
            });
        });
        return this;
    }

    @Override
    public Stream<DependencyNode> nodes() {
        return this.nodes.values().stream();
    }

    static String methodName(Method m) {
        return m.getDeclaringClass().getName() + "#" + m.getName() + "(" + Stream.of(m.getParameterTypes()).map(Class::getSimpleName).collect(Collectors.joining(", ")) + ")";
    }

    private Execution<?> createExecution(Method m, State executeBefore) {
        HashSet<Dependency> dependencies = new HashSet<Dependency>();
        try {
            for (int i = 0; i < m.getParameterCount(); ++i) {
                Parameter p = m.getParameters()[i];
                WithState ws = p.getAnnotation(WithState.class);
                if (ws == null) continue;
                this.addDependency(m, dependencies, p.getType(), ws.value());
            }
        }
        catch (CyclicReferenceException ex) {
            throw new IllegalStateException("Could not execute method " + DependencyGraphImpl.methodName(m) + " since one of its dependencies had not been injected.", ex);
        }
        return new ReflectionExecutionImpl(m.getDeclaringClass(), executeBefore, dependencies, m, this.proxyFunction.apply(m.getDeclaringClass()));
    }

    private void addDependency(Method m, Set<Dependency> dependencies, Class<?> type, State state) {
        try {
            dependencies.add(new DependencyImpl(this.getOrCreate(type), state));
        }
        catch (CyclicReferenceException ex) {
            throw new CyclicReferenceException(m.getDeclaringClass(), ex);
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalStateException("Unable to resolve " + m.toString() + " (" + type.toString() + ") at state " + state.toString(), iae);
        }
    }
}

