/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.injector.internal.execution;

import com.speedment.common.injector.MissingArgumentStrategy;
import com.speedment.common.injector.State;
import com.speedment.common.injector.dependency.Dependency;
import com.speedment.common.injector.execution.Execution;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

abstract class AbstractExecution<T>
implements Execution<T> {
    private final Class<T> type;
    private final State state;
    private final Set<Dependency> dependencies;
    private final MissingArgumentStrategy missingArgumentStrategy;

    AbstractExecution(Class<T> type, State state, Set<Dependency> dependencies, MissingArgumentStrategy missingArgumentStrategy) {
        this.type = Objects.requireNonNull(type);
        this.state = Objects.requireNonNull(state);
        this.dependencies = Objects.requireNonNull(dependencies);
        this.missingArgumentStrategy = Objects.requireNonNull(missingArgumentStrategy);
    }

    @Override
    public String getName() {
        return "abstractExecution" + this.dependencies.stream().map(dep -> dep.getNode().getRepresentedType().getSimpleName()).collect(Collectors.joining(", ", "(", ")"));
    }

    @Override
    public final Class<T> getType() {
        return this.type;
    }

    @Override
    public final State getState() {
        return this.state;
    }

    @Override
    public final Set<Dependency> getDependencies() {
        return this.dependencies;
    }

    @Override
    public MissingArgumentStrategy getMissingArgumentStrategy() {
        return this.missingArgumentStrategy;
    }

    public String toString() {
        return "<execute>(" + this.dependencies.stream().map(d -> d.getNode().getRepresentedType().getSimpleName() + "[" + d.getRequiredState().name().toLowerCase() + "]").collect(Collectors.joining(", ")) + ")";
    }
}

