/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.injector.internal.execution;

import com.speedment.common.injector.InjectorProxy;
import com.speedment.common.injector.MissingArgumentStrategy;
import com.speedment.common.injector.State;
import com.speedment.common.injector.dependency.Dependency;
import com.speedment.common.injector.execution.Execution;
import com.speedment.common.injector.internal.execution.AbstractExecution;
import com.speedment.common.injector.internal.util.ReflectionUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class ReflectionExecutionImpl<T>
extends AbstractExecution<T> {
    private final InjectorProxy injectorProxy;
    private final Method method;

    public ReflectionExecutionImpl(Class<T> component, State state, Set<Dependency> dependencies, Method method, InjectorProxy injectorProxy) {
        super(component, state, dependencies, ReflectionUtil.missingArgumentStrategy(method));
        this.method = Objects.requireNonNull(method);
        this.injectorProxy = Objects.requireNonNull(injectorProxy);
    }

    @Override
    public String getName() {
        return this.method.toString();
    }

    public Method getMethod() {
        return this.method;
    }

    @Override
    public boolean invoke(T component, Execution.ClassMapper classMapper) throws IllegalAccessException, InvocationTargetException {
        if (this.method.getParameterCount() > 0 && this.getMissingArgumentStrategy() == MissingArgumentStrategy.SKIP_INVOCATION) {
            if (Stream.of(this.method.getParameters()).map(Parameter::getType).map(classMapper::applyOrNull).anyMatch(Objects::isNull)) {
                return false;
            }
        }
        Object[] args = Stream.of(this.method.getParameters()).map(Parameter::getType).map(classMapper::apply).toArray();
        this.injectorProxy.invoke(this.method, component, args);
        return true;
    }

    @Override
    public String toString() {
        return this.getType().getSimpleName() + "#" + this.method.getName() + "(" + Stream.of(this.method.getParameters()).map(p -> p.getType().getSimpleName().substring(0, 1)).collect(Collectors.joining(", ")) + ")";
    }
}

