/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.injector.internal.util;

import com.speedment.common.injector.Injector;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public final class InjectorUtil {
    private InjectorUtil() {
    }

    public static <T> T findIn(Class<T> type, Injector injector, List<Object> instances, boolean required) {
        Optional<T> found = InjectorUtil.findAll(type, injector, instances).findFirst();
        if (required) {
            return found.orElseThrow(() -> new IllegalArgumentException("Could not find any installed implementation of " + type.getName() + "."));
        }
        return found.orElse(null);
    }

    public static <T> Stream<T> findAll(Class<T> type, Injector injector, List<Object> instances) {
        if (Injector.class.isAssignableFrom(type)) {
            Injector casted = injector;
            return Stream.of(casted);
        }
        return instances.stream().filter(inst -> type.isAssignableFrom(inst.getClass())).map(type::cast);
    }
}

