/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.injector.internal.util;

import com.speedment.common.injector.InjectorProxy;
import com.speedment.common.injector.annotation.Config;
import com.speedment.common.injector.exception.InjectorException;
import com.speedment.common.injector.internal.util.ReflectionUtil;
import com.speedment.common.logger.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Objects;
import java.util.Properties;

public final class PropertiesUtil {
    private PropertiesUtil() {
    }

    public static Properties loadProperties(Logger logger, File configFile) {
        Properties properties;
        block8: {
            properties = new Properties();
            if (configFile.exists() && configFile.canRead()) {
                try (FileInputStream in = new FileInputStream(configFile);){
                    properties.load(in);
                    break block8;
                }
                catch (IOException ex) {
                    String err = "Error loading default settings from " + configFile.getAbsolutePath() + "-file.";
                    logger.error((Throwable)ex, err);
                    throw new InjectorException(err, ex);
                }
            }
            logger.info("No configuration file '" + configFile.getAbsolutePath() + "' found.");
        }
        return properties;
    }

    public static <T> void configureParams(T instance, Properties properties, InjectorProxy injectorProxy) {
        Objects.requireNonNull(instance);
        Objects.requireNonNull(properties);
        Objects.requireNonNull(injectorProxy);
        ReflectionUtil.traverseFields(instance.getClass()).filter(f -> f.isAnnotationPresent(Config.class)).forEach(f -> PropertiesUtil.configure(instance, properties, injectorProxy, f));
    }

    private static <T> void configure(T instance, Properties properties, InjectorProxy injectorProxy, Field f) {
        Config config = f.getAnnotation(Config.class);
        String serialized = properties.containsKey(config.name()) ? properties.getProperty(config.name()) : config.value();
        PropertiesUtil.trySetField(instance, f, serialized, injectorProxy, config);
    }

    private static <T> void trySetField(T instance, Field f, String serialized, InjectorProxy injectorProxy, Config config) {
        ReflectionUtil.parse(f.getType(), serialized).ifPresent(object -> {
            try {
                injectorProxy.set(f, instance, object);
            }
            catch (ReflectiveOperationException ex) {
                throw new InjectorException("Failed to set config parameter '" + config.name() + "' in class '" + instance.getClass().getName() + "'.", ex);
            }
        });
    }
}

