/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.injector.internal.util;

import com.speedment.common.injector.InjectorProxy;
import com.speedment.common.injector.MissingArgumentStrategy;
import com.speedment.common.injector.annotation.Config;
import com.speedment.common.injector.annotation.Execute;
import com.speedment.common.injector.annotation.ExecuteBefore;
import com.speedment.common.injector.annotation.Inject;
import com.speedment.common.injector.annotation.InjectKey;
import com.speedment.common.injector.annotation.OnlyIfMissing;
import com.speedment.common.injector.exception.InjectorException;
import com.speedment.common.injector.internal.util.PropertiesUtil;
import com.speedment.common.injector.internal.util.UrlUtil;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class ReflectionUtil {
    private static final Map<Class<?>, Function<String, Object>> PARSER_MAP;

    private ReflectionUtil() {
    }

    public static Stream<Field> traverseFields(Class<?> clazz) {
        Class<?> parent = clazz.getSuperclass();
        Stream<Object> inherited = parent != null ? ReflectionUtil.traverseFields(parent) : Stream.empty();
        return Stream.concat(inherited, Stream.of(clazz.getDeclaredFields()));
    }

    public static Stream<Method> traverseMethods(Class<?> clazz) {
        return ReflectionUtil.traverseAncestors(clazz).flatMap(c -> Stream.of(c.getDeclaredMethods()));
    }

    public static Stream<Class<?>> traverseAncestors(Class<?> clazz) {
        if (clazz.getSuperclass() == null) {
            return Stream.of(clazz);
        }
        return Stream.concat(Stream.of(clazz), Stream.concat(ReflectionUtil.traverseAncestors(clazz.getSuperclass()), Stream.of(clazz.getInterfaces()))).distinct();
    }

    public static MissingArgumentStrategy missingArgumentStrategy(Executable executable) {
        Execute execute = executable.getAnnotation(Execute.class);
        ExecuteBefore executeBefore = executable.getAnnotation(ExecuteBefore.class);
        if (execute != null) {
            return execute.missingArgument();
        }
        if (executeBefore != null) {
            return executeBefore.missingArgument();
        }
        return MissingArgumentStrategy.THROW_EXCEPTION;
    }

    public static <T> Optional<T> tryToCreate(Class<T> clazz, Properties properties, List<Object> instances, Set<Class<?>> allInjectableTypes, InjectorProxy injectorProxy) throws InstantiationException {
        try {
            Optional<Constructor<T>> oConstr = ReflectionUtil.findConstructor(clazz, instances, allInjectableTypes);
            if (!oConstr.isPresent()) {
                return Optional.empty();
            }
            Constructor<T> constr = oConstr.get();
            Parameter[] params = constr.getParameters();
            Object[] args = new Object[params.length];
            for (int i = 0; i < params.length; ++i) {
                Object arg;
                Parameter param = params[i];
                Config config = param.getAnnotation(Config.class);
                if (config != null) {
                    arg = ReflectionUtil.configField(clazz, properties, param, config);
                } else {
                    arg = ReflectionUtil.notConfigField(clazz, instances, allInjectableTypes, param);
                    if (arg == null) {
                        return Optional.empty();
                    }
                }
                args[i] = arg;
            }
            T instance = injectorProxy.newInstance(constr, args);
            PropertiesUtil.configureParams(instance, properties, injectorProxy);
            return Optional.of(instance);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            throw new InjectorException(String.format("Unable to create class '%s'.", clazz.getName()), ex);
        }
    }

    private static <T> Object configField(Class<T> clazz, Properties properties, Parameter param, Config config) {
        String serialized = properties.containsKey(config.name()) ? properties.getProperty(config.name()) : config.value();
        Class<?> type = param.getType();
        return ReflectionUtil.parse(type, serialized).orElseThrow(() -> new IllegalArgumentException(String.format("Unsupported type '%s' injected into the constructor of class '%s'.", type.getName(), clazz.getName())));
    }

    private static <T> Object notConfigField(Class<T> clazz, List<Object> instances, Set<Class<?>> allInjectableTypes, Parameter param) {
        Optional<Object> value;
        Class<?> paramType = param.getType();
        Optional<Class> injectKeyClass = ReflectionUtil.traverseAncestors(paramType).filter(c -> c.isAnnotationPresent(InjectKey.class)).map(c -> c.getAnnotation(InjectKey.class).value()).findFirst();
        if (injectKeyClass.isPresent()) {
            Set needed = allInjectableTypes.stream().filter(c -> ReflectionUtil.traverseAncestors(c).anyMatch(a -> a.isAnnotationPresent(InjectKey.class) && a.getAnnotation(InjectKey.class).value().equals(injectKeyClass.get()))).collect(Collectors.toSet());
            instances.stream().map(Object::getClass).forEach(needed::remove);
            if (!needed.isEmpty()) {
                return null;
            }
        }
        if ((value = instances.stream().filter(o -> paramType.isAssignableFrom(o.getClass())).findFirst()).isPresent()) {
            return value.get();
        }
        throw new IllegalArgumentException(String.format("No instance found that match the required type '%s' in the constructor for injected class '%s'.", param.getClass().getName(), clazz.getName()));
    }

    private static <T> Optional<Constructor<T>> findConstructor(Class<T> clazz, List<Object> instances, Set<Class<?>> allInjectableTypes) {
        return Arrays.stream(clazz.getDeclaredConstructors()).sorted(Comparator.comparing(constr -> constr.isAnnotationPresent(Inject.class) ? 1 : 0)).filter(constr -> ReflectionUtil.isOnlyIfMissingConditionSatisfied(constr, allInjectableTypes)).filter(constr -> ReflectionUtil.canBeInvoked(constr, instances)).map(constr -> constr).findFirst();
    }

    public static <T> String errorMsg(Class<T> c, List<Object> instances) {
        Predicate<Constructor> onlyInject = ReflectionUtil.hasConstructorWithInjectAnnotation(c) ? constr -> constr.isAnnotationPresent(Inject.class) : constr -> true;
        return String.format("%s: %n", c.getSimpleName()) + Arrays.stream(c.getDeclaredConstructors()).map(constructor -> constructor).filter(onlyInject).map(con -> String.format("  %s %s %n %s ", con.isAnnotationPresent(Inject.class) ? "@Inject" : "       ", con.toString(), Stream.of(con.getParameters()).map(p -> {
            if (ReflectionUtil.paramIsConfig(p)) {
                return String.format("      %s %s%n", Config.class.getSimpleName(), p.toString());
            }
            return String.format("      %s %s%n", p.toString(), ReflectionUtil.paramIsInjectable(p, instances) ? "" : " <-- Missing");
        }).collect(Collectors.joining(String.format("%n", new Object[0]))))).collect(Collectors.joining(String.format("%n", new Object[0])));
    }

    private static boolean canBeInvoked(Executable executable, List<Object> instances) {
        return Stream.of(executable.getParameters()).allMatch(p -> ReflectionUtil.paramIsConfig(p) || ReflectionUtil.paramIsInjectable(p, instances));
    }

    private static boolean paramIsConfig(Parameter param) {
        return param.isAnnotationPresent(Config.class);
    }

    private static boolean paramIsInjectable(Parameter param, List<Object> instances) {
        return instances.stream().anyMatch(o -> param.getType().isAssignableFrom(o.getClass()));
    }

    private static boolean hasConstructorWithInjectAnnotation(Class<?> clazz) {
        return Stream.of(clazz.getDeclaredConstructors()).anyMatch(constr -> constr.isAnnotationPresent(Inject.class));
    }

    private static boolean isOnlyIfMissingConditionSatisfied(Constructor<?> constr, Set<Class<?>> allInjectableTypes) {
        OnlyIfMissing missing = constr.getAnnotation(OnlyIfMissing.class);
        if (missing == null) {
            return true;
        }
        return Stream.of(missing.value()).noneMatch(missingType -> allInjectableTypes.stream().anyMatch(missingType::isAssignableFrom));
    }

    public static Optional<Object> parse(Type type, String serialized) {
        return Optional.ofNullable(PARSER_MAP.get(type)).map(m -> m.apply(serialized));
    }

    static {
        Function<String, Object> characterMapper = s -> {
            if (s.length() == 1) {
                return Character.valueOf(s.charAt(0));
            }
            throw new IllegalArgumentException("Value '" + s + "' is to long to be parsed into a field of type char.");
        };
        HashMap<Class<URL>, Function<String, Object>> map = new HashMap<Class<URL>, Function<String, Object>>();
        map.put(Boolean.TYPE, Boolean::parseBoolean);
        map.put(Boolean.class, Boolean::parseBoolean);
        map.put(Byte.TYPE, Byte::parseByte);
        map.put(Byte.class, Byte::parseByte);
        map.put(Short.TYPE, Short::parseShort);
        map.put(Short.class, Short::parseShort);
        map.put(Integer.TYPE, Integer::parseInt);
        map.put(Integer.class, Integer::parseInt);
        map.put(Long.TYPE, Long::parseLong);
        map.put(Long.class, Long::parseLong);
        map.put(Float.TYPE, Float::parseFloat);
        map.put(Float.class, Float::parseFloat);
        map.put(Double.TYPE, Double::parseDouble);
        map.put(Double.class, Double::parseDouble);
        map.put(String.class, s -> s);
        map.put(Character.TYPE, characterMapper);
        map.put(Character.class, characterMapper);
        map.put(File.class, File::new);
        map.put(URL.class, UrlUtil::tryCreateURL);
        PARSER_MAP = Collections.unmodifiableMap(map);
    }
}

