/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.invariant;

import java.util.function.Function;

public final class DoubleRangeUtil {
    private DoubleRangeUtil() {
    }

    public static double requirePositive(double val) {
        if (Double.compare(val, 0.0) <= 0) {
            throw new IllegalArgumentException(val + " is not positive.");
        }
        return val;
    }

    public static double requireNegative(double val) {
        if (Double.compare(val, 0.0) >= 0) {
            throw new IllegalArgumentException(val + " is not negative.");
        }
        return val;
    }

    public static double requireZero(double val) {
        if (Double.compare(val, 0.0) != 0) {
            throw new IllegalArgumentException(val + " is not zero.");
        }
        return val;
    }

    public static double requireNonPositive(double val) {
        if (Double.compare(val, 0.0) > 0) {
            throw new IllegalArgumentException(val + " is positive.");
        }
        return val;
    }

    public static double requireNonNegative(double val) {
        if (Double.compare(val, 0.0) < 0) {
            throw new IllegalArgumentException(val + " is negative.");
        }
        return val;
    }

    public static double requireNonZero(double val) {
        if (Double.compare(val, 0.0) == 0) {
            throw new IllegalArgumentException(val + " is zero.");
        }
        return val;
    }

    public static double requireEquals(double val, double otherVal) {
        if (Double.compare(val, otherVal) != 0) {
            throw new IllegalArgumentException(val + " is not equal to " + otherVal);
        }
        return val;
    }

    public static double requireNotEquals(double val, double otherVal) {
        if (val == otherVal) {
            throw new IllegalArgumentException(val + " is equal to." + otherVal);
        }
        return val;
    }

    public static double requireInRange(double val, double first, double lastExclusive) {
        if (val < first || val >= lastExclusive) {
            throw new IllegalArgumentException(val + " is not in the range [" + first + ", " + lastExclusive + ")");
        }
        return val;
    }

    public static double requireInRangeClosed(double val, double first, double lastInclusive) {
        if (val < first || val > lastInclusive) {
            throw new IllegalArgumentException(val + " is not in the range [" + first + ", " + lastInclusive + "]");
        }
        return val;
    }

    public static <E extends RuntimeException> double requirePositive(double val, Function<String, E> exceptionConstructor) {
        if (val <= 0.0) {
            throw (RuntimeException)exceptionConstructor.apply(val + " is not positive.");
        }
        return val;
    }

    public static <E extends RuntimeException> double requireNegative(double val, Function<String, E> exceptionConstructor) {
        if (val >= 0.0) {
            throw (RuntimeException)exceptionConstructor.apply(val + " is not negative.");
        }
        return val;
    }

    public static <E extends RuntimeException> double requireZero(double val, Function<String, E> exceptionConstructor) {
        if (val != 0.0) {
            throw (RuntimeException)exceptionConstructor.apply(val + " is not zero.");
        }
        return val;
    }

    public static <E extends RuntimeException> double requireNonPositive(double val, Function<String, E> exceptionConstructor) {
        if (val > 0.0) {
            throw (RuntimeException)exceptionConstructor.apply(val + " is positive.");
        }
        return val;
    }

    public static <E extends RuntimeException> double requireNonNegative(double val, Function<String, E> exceptionConstructor) {
        if (val < 0.0) {
            throw (RuntimeException)exceptionConstructor.apply(val + " is negative.");
        }
        return val;
    }

    public static <E extends RuntimeException> double requireNonZero(double val, Function<String, E> exceptionConstructor) {
        if (val == 0.0) {
            throw (RuntimeException)exceptionConstructor.apply(val + " is zero.");
        }
        return val;
    }

    public static <E extends RuntimeException> double requireEquals(double val, double otherVal, Function<String, E> exceptionConstructor) {
        if (val != otherVal) {
            throw (RuntimeException)exceptionConstructor.apply(val + " is not equal to " + otherVal);
        }
        return val;
    }

    public static <E extends RuntimeException> double requireNotEquals(double val, double otherVal, Function<String, E> exceptionConstructor) {
        if (val == otherVal) {
            throw (RuntimeException)exceptionConstructor.apply(val + " is equal to." + otherVal);
        }
        return val;
    }

    public static <E extends RuntimeException> double requireInRange(double val, double first, double lastExclusive, Function<String, E> exceptionConstructor) {
        if (val < first || val >= lastExclusive) {
            throw (RuntimeException)exceptionConstructor.apply(val + " is not in the range [" + first + ", " + lastExclusive + ")");
        }
        return val;
    }

    public static <E extends RuntimeException> double requireInRangeClosed(double val, double first, double lastInclusive, Function<String, E> exceptionConstructor) {
        if (val < first || val > lastInclusive) {
            throw (RuntimeException)exceptionConstructor.apply(val + " is not in the range [" + first + ", " + lastInclusive + "]");
        }
        return val;
    }
}

